/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.IMonitorInitializer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.Monitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.util.SlidingExpirationCacheWithCleanupThread;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class DefaultMonitorService
implements IMonitorService {
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final Executor ABORT_EXECUTOR = Executors.newSingleThreadExecutor();
    protected static final SlidingExpirationCacheWithCleanupThread<String, IMonitor> monitors = new SlidingExpirationCacheWithCleanupThread(IMonitor::canDispose, monitor -> {
        try {
            monitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected final Log logger;
    protected final IMonitorInitializer monitorInitializer;

    public DefaultMonitorService(Log logger) {
        this((hostInfo, propertySet, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount) -> new Monitor(new BasicConnectionProvider(), hostInfo, propertySet, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, logger), logger);
    }

    DefaultMonitorService(IMonitorInitializer monitorInitializer, Log logger) {
        this.monitorInitializer = monitorInitializer;
        this.logger = logger;
    }

    @Override
    public MonitorConnectionContext startMonitoring(JdbcConnection connectionToAbort, HostInfo hostInfo, PropertySet propertySet, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        IMonitor monitor = this.getMonitor(hostInfo, propertySet, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
        MonitorConnectionContext context = new MonitorConnectionContext(connectionToAbort);
        monitor.startMonitoring(context);
        return context;
    }

    @Override
    public void stopMonitoring(@NonNull MonitorConnectionContext context, @NonNull Connection connectionToAbort) {
        if (context.shouldAbort()) {
            context.setInactive();
            try {
                connectionToAbort.abort(ABORT_EXECUTOR);
                connectionToAbort.close();
            }
            catch (SQLException sqlEx) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.logTrace(String.format("[efm2.DefaultMonitorService.stopMonitoring]: Exception during aborting connection: %s", sqlEx.getMessage()));
                }
            }
        } else {
            context.setInactive();
        }
    }

    @Override
    public void releaseResources() {
    }

    protected IMonitor getMonitor(HostInfo hostInfo, PropertySet propertySet, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        String monitorKey = String.format("%d:%d:%d:%s", failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, hostInfo.getHostPortPair());
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(propertySet.getIntegerProperty(PropertyKey.monitorDisposalTime).getValue().intValue());
        return monitors.computeIfAbsent(monitorKey, key -> this.monitorInitializer.createMonitor(hostInfo, propertySet, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount), cacheExpirationNano);
    }
}

