/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.MariaDBExceptionHandler;
import software.amazon.jdbc.hostlistprovider.ConnectionStringHostListProvider;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;

public class MariaDbDialect
implements Dialect {
    private static final List<String> dialectUpdateCandidates = Arrays.asList("aurora-mysql", "rds-multi-az-mysql-cluster", "rds-mysql", "mysql");
    private static MariaDBExceptionHandler mariaDBExceptionHandler;
    private static final EnumSet<FailoverRestriction> NO_RESTRICTIONS;

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (mariaDBExceptionHandler == null) {
            mariaDBExceptionHandler = new MariaDBExceptionHandler();
        }
        return mariaDBExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return "SELECT CONCAT(@@hostname, ':', @@port)";
    }

    @Override
    public String getServerVersionQuery() {
        return "SELECT VERSION()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(this.getServerVersionQuery());
            while (true) {
                if (rs.next()) {
                    String columnValue = rs.getString(1);
                    if (columnValue == null || !columnValue.toLowerCase().contains("mariadb")) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return ConnectionStringHostListProvider::new;
    }

    @Override
    public void prepareConnectProperties(@NonNull Properties connectProperties, @NonNull String protocol, @NonNull HostSpec hostSpec) {
    }

    @Override
    public EnumSet<FailoverRestriction> getFailoverRestrictions() {
        return NO_RESTRICTIONS;
    }

    static {
        NO_RESTRICTIONS = EnumSet.noneOf(FailoverRestriction.class);
    }
}

