/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsListCopier;
import software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBrowserSettingsResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListBrowserSettingsResponse> {
    private static final SdkField<List<BrowserSettingsSummary>> BROWSER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("browserSettings").getter(ListBrowserSettingsResponse.getter(ListBrowserSettingsResponse::browserSettings)).setter(ListBrowserSettingsResponse.setter(Builder::browserSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrowserSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBrowserSettingsResponse.getter(ListBrowserSettingsResponse::nextToken)).setter(ListBrowserSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SETTINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("browserSettings", BROWSER_SETTINGS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BrowserSettingsSummary> browserSettings;
    private final String nextToken;

    private ListBrowserSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.browserSettings = builder.browserSettings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBrowserSettings() {
        return this.browserSettings != null && !(this.browserSettings instanceof SdkAutoConstructList);
    }

    public final List<BrowserSettingsSummary> browserSettings() {
        return this.browserSettings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrowserSettings() ? this.browserSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrowserSettingsResponse)) {
            return false;
        }
        ListBrowserSettingsResponse other = (ListBrowserSettingsResponse)((Object)obj);
        return this.hasBrowserSettings() == other.hasBrowserSettings() && Objects.equals(this.browserSettings(), other.browserSettings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBrowserSettingsResponse").add("BrowserSettings", this.hasBrowserSettings() ? this.browserSettings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserSettings": {
                return Optional.ofNullable(clazz.cast(this.browserSettings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBrowserSettingsResponse, T> g) {
        return obj -> g.apply((ListBrowserSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private List<BrowserSettingsSummary> browserSettings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrowserSettingsResponse model) {
            super(model);
            this.browserSettings(model.browserSettings);
            this.nextToken(model.nextToken);
        }

        public final List<BrowserSettingsSummary.Builder> getBrowserSettings() {
            List<BrowserSettingsSummary.Builder> result = BrowserSettingsListCopier.copyToBuilder(this.browserSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrowserSettings(Collection<BrowserSettingsSummary.BuilderImpl> browserSettings) {
            this.browserSettings = BrowserSettingsListCopier.copyFromBuilder(browserSettings);
        }

        @Override
        public final Builder browserSettings(Collection<BrowserSettingsSummary> browserSettings) {
            this.browserSettings = BrowserSettingsListCopier.copy(browserSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSettings(BrowserSettingsSummary ... browserSettings) {
            this.browserSettings(Arrays.asList(browserSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSettings(Consumer<BrowserSettingsSummary.Builder> ... browserSettings) {
            this.browserSettings(Stream.of(browserSettings).map(c -> (BrowserSettingsSummary)((BrowserSettingsSummary.Builder)BrowserSettingsSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBrowserSettingsResponse build() {
            return new ListBrowserSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBrowserSettingsResponse> {
        public Builder browserSettings(Collection<BrowserSettingsSummary> var1);

        public Builder browserSettings(BrowserSettingsSummary ... var1);

        public Builder browserSettings(Consumer<BrowserSettingsSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

