/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkspaceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingCreateStandbyWorkspacesRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingCreateStandbyWorkspacesRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(PendingCreateStandbyWorkspacesRequest.getter(PendingCreateStandbyWorkspacesRequest::userName)).setter(PendingCreateStandbyWorkspacesRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(PendingCreateStandbyWorkspacesRequest.getter(PendingCreateStandbyWorkspacesRequest::directoryId)).setter(PendingCreateStandbyWorkspacesRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(PendingCreateStandbyWorkspacesRequest.getter(PendingCreateStandbyWorkspacesRequest::stateAsString)).setter(PendingCreateStandbyWorkspacesRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(PendingCreateStandbyWorkspacesRequest.getter(PendingCreateStandbyWorkspacesRequest::workspaceId)).setter(PendingCreateStandbyWorkspacesRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, DIRECTORY_ID_FIELD, STATE_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserName", USER_NAME_FIELD);
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("State", STATE_FIELD);
            this.put("WorkspaceId", WORKSPACE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String directoryId;
    private final String state;
    private final String workspaceId;

    private PendingCreateStandbyWorkspacesRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.directoryId = builder.directoryId;
        this.state = builder.state;
        this.workspaceId = builder.workspaceId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final WorkspaceState state() {
        return WorkspaceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingCreateStandbyWorkspacesRequest)) {
            return false;
        }
        PendingCreateStandbyWorkspacesRequest other = (PendingCreateStandbyWorkspacesRequest)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"PendingCreateStandbyWorkspacesRequest").add("UserName", (Object)this.userName()).add("DirectoryId", (Object)this.directoryId()).add("State", (Object)this.stateAsString()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PendingCreateStandbyWorkspacesRequest, T> g) {
        return obj -> g.apply((PendingCreateStandbyWorkspacesRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String directoryId;
        private String state;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingCreateStandbyWorkspacesRequest model) {
            this.userName(model.userName);
            this.directoryId(model.directoryId);
            this.state(model.state);
            this.workspaceId(model.workspaceId);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public PendingCreateStandbyWorkspacesRequest build() {
            return new PendingCreateStandbyWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingCreateStandbyWorkspacesRequest> {
        public Builder userName(String var1);

        public Builder directoryId(String var1);

        public Builder state(String var1);

        public Builder state(WorkspaceState var1);

        public Builder workspaceId(String var1);
    }
}

