/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.StreamingProperties;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyStreamingPropertiesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ModifyStreamingPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ModifyStreamingPropertiesRequest.getter(ModifyStreamingPropertiesRequest::resourceId)).setter(ModifyStreamingPropertiesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<StreamingProperties> STREAMING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingProperties").getter(ModifyStreamingPropertiesRequest.getter(ModifyStreamingPropertiesRequest::streamingProperties)).setter(ModifyStreamingPropertiesRequest.setter(Builder::streamingProperties)).constructor(StreamingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, STREAMING_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("StreamingProperties", STREAMING_PROPERTIES_FIELD);
        }
    });
    private final String resourceId;
    private final StreamingProperties streamingProperties;

    private ModifyStreamingPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.streamingProperties = builder.streamingProperties;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final StreamingProperties streamingProperties() {
        return this.streamingProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyStreamingPropertiesRequest)) {
            return false;
        }
        ModifyStreamingPropertiesRequest other = (ModifyStreamingPropertiesRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.streamingProperties(), other.streamingProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyStreamingPropertiesRequest").add("ResourceId", (Object)this.resourceId()).add("StreamingProperties", (Object)this.streamingProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "StreamingProperties": {
                return Optional.ofNullable(clazz.cast(this.streamingProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyStreamingPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyStreamingPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private StreamingProperties streamingProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyStreamingPropertiesRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.streamingProperties(model.streamingProperties);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final StreamingProperties.Builder getStreamingProperties() {
            return this.streamingProperties != null ? this.streamingProperties.toBuilder() : null;
        }

        public final void setStreamingProperties(StreamingProperties.BuilderImpl streamingProperties) {
            this.streamingProperties = streamingProperties != null ? streamingProperties.build() : null;
        }

        @Override
        public final Builder streamingProperties(StreamingProperties streamingProperties) {
            this.streamingProperties = streamingProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyStreamingPropertiesRequest build() {
            return new ModifyStreamingPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyStreamingPropertiesRequest> {
        public Builder resourceId(String var1);

        public Builder streamingProperties(StreamingProperties var1);

        default public Builder streamingProperties(Consumer<StreamingProperties.Builder> streamingProperties) {
            return this.streamingProperties((StreamingProperties)((StreamingProperties.Builder)StreamingProperties.builder().applyMutation(streamingProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

