/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation;
import software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceAssociationsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceAssociationsResponse> {
    private static final SdkField<List<WorkspaceResourceAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(DescribeWorkspaceAssociationsResponse.getter(DescribeWorkspaceAssociationsResponse::associations)).setter(DescribeWorkspaceAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceResourceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Associations", ASSOCIATIONS_FIELD);
        }
    });
    private final List<WorkspaceResourceAssociation> associations;

    private DescribeWorkspaceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceResourceAssociation> associations() {
        return this.associations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceAssociationsResponse)) {
            return false;
        }
        DescribeWorkspaceAssociationsResponse other = (DescribeWorkspaceAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceResourceAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
        }

        public final List<WorkspaceResourceAssociation.Builder> getAssociations() {
            List<WorkspaceResourceAssociation.Builder> result = WorkspaceResourceAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<WorkspaceResourceAssociation.BuilderImpl> associations) {
            this.associations = WorkspaceResourceAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<WorkspaceResourceAssociation> associations) {
            this.associations = WorkspaceResourceAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(WorkspaceResourceAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<WorkspaceResourceAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (WorkspaceResourceAssociation)((WorkspaceResourceAssociation.Builder)WorkspaceResourceAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeWorkspaceAssociationsResponse build() {
            return new DescribeWorkspaceAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceAssociationsResponse> {
        public Builder associations(Collection<WorkspaceResourceAssociation> var1);

        public Builder associations(WorkspaceResourceAssociation ... var1);

        public Builder associations(Consumer<WorkspaceResourceAssociation.Builder> ... var1);
    }
}

