/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasIdListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionAliasesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeConnectionAliasesRequest> {
    private static final SdkField<List<String>> ALIAS_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AliasIds").getter(DescribeConnectionAliasesRequest.getter(DescribeConnectionAliasesRequest::aliasIds)).setter(DescribeConnectionAliasesRequest.setter(Builder::aliasIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DescribeConnectionAliasesRequest.getter(DescribeConnectionAliasesRequest::resourceId)).setter(DescribeConnectionAliasesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeConnectionAliasesRequest.getter(DescribeConnectionAliasesRequest::limit)).setter(DescribeConnectionAliasesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConnectionAliasesRequest.getter(DescribeConnectionAliasesRequest::nextToken)).setter(DescribeConnectionAliasesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_IDS_FIELD, RESOURCE_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AliasIds", ALIAS_IDS_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> aliasIds;
    private final String resourceId;
    private final Integer limit;
    private final String nextToken;

    private DescribeConnectionAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.aliasIds = builder.aliasIds;
        this.resourceId = builder.resourceId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAliasIds() {
        return this.aliasIds != null && !(this.aliasIds instanceof SdkAutoConstructList);
    }

    public final List<String> aliasIds() {
        return this.aliasIds;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliasIds() ? this.aliasIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionAliasesRequest)) {
            return false;
        }
        DescribeConnectionAliasesRequest other = (DescribeConnectionAliasesRequest)((Object)obj);
        return this.hasAliasIds() == other.hasAliasIds() && Objects.equals(this.aliasIds(), other.aliasIds()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectionAliasesRequest").add("AliasIds", this.hasAliasIds() ? this.aliasIds() : null).add("ResourceId", (Object)this.resourceId()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasIds": {
                return Optional.ofNullable(clazz.cast(this.aliasIds()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionAliasesRequest, T> g) {
        return obj -> g.apply((DescribeConnectionAliasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> aliasIds = DefaultSdkAutoConstructList.getInstance();
        private String resourceId;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionAliasesRequest model) {
            super(model);
            this.aliasIds(model.aliasIds);
            this.resourceId(model.resourceId);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAliasIds() {
            if (this.aliasIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliasIds;
        }

        public final void setAliasIds(Collection<String> aliasIds) {
            this.aliasIds = ConnectionAliasIdListCopier.copy(aliasIds);
        }

        @Override
        public final Builder aliasIds(Collection<String> aliasIds) {
            this.aliasIds = ConnectionAliasIdListCopier.copy(aliasIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasIds(String ... aliasIds) {
            this.aliasIds(Arrays.asList(aliasIds));
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectionAliasesRequest build() {
            return new DescribeConnectionAliasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionAliasesRequest> {
        public Builder aliasIds(Collection<String> var1);

        public Builder aliasIds(String ... var1);

        public Builder resourceId(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

