/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AssociationState;
import software.amazon.awssdk.services.workspaces.model.AssociationStateReason;
import software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BundleResourceAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BundleResourceAssociation> {
    private static final SdkField<String> ASSOCIATED_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceId").getter(BundleResourceAssociation.getter(BundleResourceAssociation::associatedResourceId)).setter(BundleResourceAssociation.setter(Builder::associatedResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceId").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceType").getter(BundleResourceAssociation.getter(BundleResourceAssociation::associatedResourceTypeAsString)).setter(BundleResourceAssociation.setter(Builder::associatedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceType").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(BundleResourceAssociation.getter(BundleResourceAssociation::bundleId)).setter(BundleResourceAssociation.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(BundleResourceAssociation.getter(BundleResourceAssociation::created)).setter(BundleResourceAssociation.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(BundleResourceAssociation.getter(BundleResourceAssociation::lastUpdatedTime)).setter(BundleResourceAssociation.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(BundleResourceAssociation.getter(BundleResourceAssociation::stateAsString)).setter(BundleResourceAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<AssociationStateReason> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateReason").getter(BundleResourceAssociation.getter(BundleResourceAssociation::stateReason)).setter(BundleResourceAssociation.setter(Builder::stateReason)).constructor(AssociationStateReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_RESOURCE_ID_FIELD, ASSOCIATED_RESOURCE_TYPE_FIELD, BUNDLE_ID_FIELD, CREATED_FIELD, LAST_UPDATED_TIME_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssociatedResourceId", ASSOCIATED_RESOURCE_ID_FIELD);
            this.put("AssociatedResourceType", ASSOCIATED_RESOURCE_TYPE_FIELD);
            this.put("BundleId", BUNDLE_ID_FIELD);
            this.put("Created", CREATED_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StateReason", STATE_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String associatedResourceId;
    private final String associatedResourceType;
    private final String bundleId;
    private final Instant created;
    private final Instant lastUpdatedTime;
    private final String state;
    private final AssociationStateReason stateReason;

    private BundleResourceAssociation(BuilderImpl builder) {
        this.associatedResourceId = builder.associatedResourceId;
        this.associatedResourceType = builder.associatedResourceType;
        this.bundleId = builder.bundleId;
        this.created = builder.created;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String associatedResourceId() {
        return this.associatedResourceId;
    }

    public final BundleAssociatedResourceType associatedResourceType() {
        return BundleAssociatedResourceType.fromValue(this.associatedResourceType);
    }

    public final String associatedResourceTypeAsString() {
        return this.associatedResourceType;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final AssociationState state() {
        return AssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final AssociationStateReason stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleResourceAssociation)) {
            return false;
        }
        BundleResourceAssociation other = (BundleResourceAssociation)obj;
        return Objects.equals(this.associatedResourceId(), other.associatedResourceId()) && Objects.equals(this.associatedResourceTypeAsString(), other.associatedResourceTypeAsString()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"BundleResourceAssociation").add("AssociatedResourceId", (Object)this.associatedResourceId()).add("AssociatedResourceType", (Object)this.associatedResourceTypeAsString()).add("BundleId", (Object)this.bundleId()).add("Created", (Object)this.created()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedResourceId": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceId()));
            }
            case "AssociatedResourceType": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceTypeAsString()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BundleResourceAssociation, T> g) {
        return obj -> g.apply((BundleResourceAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associatedResourceId;
        private String associatedResourceType;
        private String bundleId;
        private Instant created;
        private Instant lastUpdatedTime;
        private String state;
        private AssociationStateReason stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleResourceAssociation model) {
            this.associatedResourceId(model.associatedResourceId);
            this.associatedResourceType(model.associatedResourceType);
            this.bundleId(model.bundleId);
            this.created(model.created);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getAssociatedResourceId() {
            return this.associatedResourceId;
        }

        public final void setAssociatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
        }

        @Override
        public final Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            return this;
        }

        public final String getAssociatedResourceType() {
            return this.associatedResourceType;
        }

        public final void setAssociatedResourceType(String associatedResourceType) {
            this.associatedResourceType = associatedResourceType;
        }

        @Override
        public final Builder associatedResourceType(String associatedResourceType) {
            this.associatedResourceType = associatedResourceType;
            return this;
        }

        @Override
        public final Builder associatedResourceType(BundleAssociatedResourceType associatedResourceType) {
            this.associatedResourceType(associatedResourceType == null ? null : associatedResourceType.toString());
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final AssociationStateReason.Builder getStateReason() {
            return this.stateReason != null ? this.stateReason.toBuilder() : null;
        }

        public final void setStateReason(AssociationStateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(AssociationStateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public BundleResourceAssociation build() {
            return new BundleResourceAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BundleResourceAssociation> {
        public Builder associatedResourceId(String var1);

        public Builder associatedResourceType(String var1);

        public Builder associatedResourceType(BundleAssociatedResourceType var1);

        public Builder bundleId(String var1);

        public Builder created(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder state(String var1);

        public Builder state(AssociationState var1);

        public Builder stateReason(AssociationStateReason var1);

        default public Builder stateReason(Consumer<AssociationStateReason.Builder> stateReason) {
            return this.stateReason((AssociationStateReason)((AssociationStateReason.Builder)AssociationStateReason.builder().applyMutation(stateReason)).build());
        }
    }
}

