/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateWorkspaceApplicationResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, AssociateWorkspaceApplicationResponse> {
    private static final SdkField<WorkspaceResourceAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Association").getter(AssociateWorkspaceApplicationResponse.getter(AssociateWorkspaceApplicationResponse::association)).setter(AssociateWorkspaceApplicationResponse.setter(Builder::association)).constructor(WorkspaceResourceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Association", ASSOCIATION_FIELD);
        }
    });
    private final WorkspaceResourceAssociation association;

    private AssociateWorkspaceApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    public final WorkspaceResourceAssociation association() {
        return this.association;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWorkspaceApplicationResponse)) {
            return false;
        }
        AssociateWorkspaceApplicationResponse other = (AssociateWorkspaceApplicationResponse)((Object)obj);
        return Objects.equals(this.association(), other.association());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateWorkspaceApplicationResponse").add("Association", (Object)this.association()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateWorkspaceApplicationResponse, T> g) {
        return obj -> g.apply((AssociateWorkspaceApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private WorkspaceResourceAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWorkspaceApplicationResponse model) {
            super(model);
            this.association(model.association);
        }

        public final WorkspaceResourceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        public final void setAssociation(WorkspaceResourceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(WorkspaceResourceAssociation association) {
            this.association = association;
            return this;
        }

        @Override
        public AssociateWorkspaceApplicationResponse build() {
            return new AssociateWorkspaceApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateWorkspaceApplicationResponse> {
        public Builder association(WorkspaceResourceAssociation var1);

        default public Builder association(Consumer<WorkspaceResourceAssociation.Builder> association) {
            return this.association((WorkspaceResourceAssociation)((WorkspaceResourceAssociation.Builder)WorkspaceResourceAssociation.builder().applyMutation(association)).build());
        }
    }
}

