/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AccountLinkStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountLink
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountLink> {
    private static final SdkField<String> ACCOUNT_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountLinkId").getter(AccountLink.getter(AccountLink::accountLinkId)).setter(AccountLink.setter(Builder::accountLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinkId").build()}).build();
    private static final SdkField<String> ACCOUNT_LINK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountLinkStatus").getter(AccountLink.getter(AccountLink::accountLinkStatusAsString)).setter(AccountLink.setter(Builder::accountLinkStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinkStatus").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceAccountId").getter(AccountLink.getter(AccountLink::sourceAccountId)).setter(AccountLink.setter(Builder::sourceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountId").build()}).build();
    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAccountId").getter(AccountLink.getter(AccountLink::targetAccountId)).setter(AccountLink.setter(Builder::targetAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LINK_ID_FIELD, ACCOUNT_LINK_STATUS_FIELD, SOURCE_ACCOUNT_ID_FIELD, TARGET_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountLinkId", ACCOUNT_LINK_ID_FIELD);
            this.put("AccountLinkStatus", ACCOUNT_LINK_STATUS_FIELD);
            this.put("SourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
            this.put("TargetAccountId", TARGET_ACCOUNT_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountLinkId;
    private final String accountLinkStatus;
    private final String sourceAccountId;
    private final String targetAccountId;

    private AccountLink(BuilderImpl builder) {
        this.accountLinkId = builder.accountLinkId;
        this.accountLinkStatus = builder.accountLinkStatus;
        this.sourceAccountId = builder.sourceAccountId;
        this.targetAccountId = builder.targetAccountId;
    }

    public final String accountLinkId() {
        return this.accountLinkId;
    }

    public final AccountLinkStatusEnum accountLinkStatus() {
        return AccountLinkStatusEnum.fromValue(this.accountLinkStatus);
    }

    public final String accountLinkStatusAsString() {
        return this.accountLinkStatus;
    }

    public final String sourceAccountId() {
        return this.sourceAccountId;
    }

    public final String targetAccountId() {
        return this.targetAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLinkStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLink)) {
            return false;
        }
        AccountLink other = (AccountLink)obj;
        return Objects.equals(this.accountLinkId(), other.accountLinkId()) && Objects.equals(this.accountLinkStatusAsString(), other.accountLinkStatusAsString()) && Objects.equals(this.sourceAccountId(), other.sourceAccountId()) && Objects.equals(this.targetAccountId(), other.targetAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"AccountLink").add("AccountLinkId", (Object)this.accountLinkId()).add("AccountLinkStatus", (Object)this.accountLinkStatusAsString()).add("SourceAccountId", (Object)this.sourceAccountId()).add("TargetAccountId", (Object)this.targetAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountLinkId": {
                return Optional.ofNullable(clazz.cast(this.accountLinkId()));
            }
            case "AccountLinkStatus": {
                return Optional.ofNullable(clazz.cast(this.accountLinkStatusAsString()));
            }
            case "SourceAccountId": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountId()));
            }
            case "TargetAccountId": {
                return Optional.ofNullable(clazz.cast(this.targetAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountLink, T> g) {
        return obj -> g.apply((AccountLink)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountLinkId;
        private String accountLinkStatus;
        private String sourceAccountId;
        private String targetAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLink model) {
            this.accountLinkId(model.accountLinkId);
            this.accountLinkStatus(model.accountLinkStatus);
            this.sourceAccountId(model.sourceAccountId);
            this.targetAccountId(model.targetAccountId);
        }

        public final String getAccountLinkId() {
            return this.accountLinkId;
        }

        public final void setAccountLinkId(String accountLinkId) {
            this.accountLinkId = accountLinkId;
        }

        @Override
        public final Builder accountLinkId(String accountLinkId) {
            this.accountLinkId = accountLinkId;
            return this;
        }

        public final String getAccountLinkStatus() {
            return this.accountLinkStatus;
        }

        public final void setAccountLinkStatus(String accountLinkStatus) {
            this.accountLinkStatus = accountLinkStatus;
        }

        @Override
        public final Builder accountLinkStatus(String accountLinkStatus) {
            this.accountLinkStatus = accountLinkStatus;
            return this;
        }

        @Override
        public final Builder accountLinkStatus(AccountLinkStatusEnum accountLinkStatus) {
            this.accountLinkStatus(accountLinkStatus == null ? null : accountLinkStatus.toString());
            return this;
        }

        public final String getSourceAccountId() {
            return this.sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final String getTargetAccountId() {
            return this.targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public AccountLink build() {
            return new AccountLink(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountLink> {
        public Builder accountLinkId(String var1);

        public Builder accountLinkStatus(String var1);

        public Builder accountLinkStatus(AccountLinkStatusEnum var1);

        public Builder sourceAccountId(String var1);

        public Builder targetAccountId(String var1);
    }
}

