/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.AccessEffect;
import software.amazon.awssdk.services.workmail.model.ImpersonationMatchedRule;
import software.amazon.awssdk.services.workmail.model.ImpersonationMatchedRuleListCopier;
import software.amazon.awssdk.services.workmail.model.ImpersonationRoleType;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImpersonationRoleEffectResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, GetImpersonationRoleEffectResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetImpersonationRoleEffectResponse.getter(GetImpersonationRoleEffectResponse::typeAsString)).setter(GetImpersonationRoleEffectResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(GetImpersonationRoleEffectResponse.getter(GetImpersonationRoleEffectResponse::effectAsString)).setter(GetImpersonationRoleEffectResponse.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<List<ImpersonationMatchedRule>> MATCHED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchedRules").getter(GetImpersonationRoleEffectResponse.getter(GetImpersonationRoleEffectResponse::matchedRules)).setter(GetImpersonationRoleEffectResponse.setter(Builder::matchedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpersonationMatchedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EFFECT_FIELD, MATCHED_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Effect", EFFECT_FIELD);
            this.put("MatchedRules", MATCHED_RULES_FIELD);
        }
    });
    private final String type;
    private final String effect;
    private final List<ImpersonationMatchedRule> matchedRules;

    private GetImpersonationRoleEffectResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.effect = builder.effect;
        this.matchedRules = builder.matchedRules;
    }

    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AccessEffect effect() {
        return AccessEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasMatchedRules() {
        return this.matchedRules != null && !(this.matchedRules instanceof SdkAutoConstructList);
    }

    public final List<ImpersonationMatchedRule> matchedRules() {
        return this.matchedRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedRules() ? this.matchedRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImpersonationRoleEffectResponse)) {
            return false;
        }
        GetImpersonationRoleEffectResponse other = (GetImpersonationRoleEffectResponse)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasMatchedRules() == other.hasMatchedRules() && Objects.equals(this.matchedRules(), other.matchedRules());
    }

    public final String toString() {
        return ToString.builder((String)"GetImpersonationRoleEffectResponse").add("Type", (Object)this.typeAsString()).add("Effect", (Object)this.effectAsString()).add("MatchedRules", this.hasMatchedRules() ? this.matchedRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "MatchedRules": {
                return Optional.ofNullable(clazz.cast(this.matchedRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetImpersonationRoleEffectResponse, T> g) {
        return obj -> g.apply((GetImpersonationRoleEffectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String type;
        private String effect;
        private List<ImpersonationMatchedRule> matchedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetImpersonationRoleEffectResponse model) {
            super(model);
            this.type(model.type);
            this.effect(model.effect);
            this.matchedRules(model.matchedRules);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final List<ImpersonationMatchedRule.Builder> getMatchedRules() {
            List<ImpersonationMatchedRule.Builder> result = ImpersonationMatchedRuleListCopier.copyToBuilder(this.matchedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchedRules(Collection<ImpersonationMatchedRule.BuilderImpl> matchedRules) {
            this.matchedRules = ImpersonationMatchedRuleListCopier.copyFromBuilder(matchedRules);
        }

        @Override
        public final Builder matchedRules(Collection<ImpersonationMatchedRule> matchedRules) {
            this.matchedRules = ImpersonationMatchedRuleListCopier.copy(matchedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(ImpersonationMatchedRule ... matchedRules) {
            this.matchedRules(Arrays.asList(matchedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(Consumer<ImpersonationMatchedRule.Builder> ... matchedRules) {
            this.matchedRules(Stream.of(matchedRules).map(c -> (ImpersonationMatchedRule)((ImpersonationMatchedRule.Builder)ImpersonationMatchedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetImpersonationRoleEffectResponse build() {
            return new GetImpersonationRoleEffectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImpersonationRoleEffectResponse> {
        public Builder type(String var1);

        public Builder type(ImpersonationRoleType var1);

        public Builder effect(String var1);

        public Builder effect(AccessEffect var1);

        public Builder matchedRules(Collection<ImpersonationMatchedRule> var1);

        public Builder matchedRules(ImpersonationMatchedRule ... var1);

        public Builder matchedRules(Consumer<ImpersonationMatchedRule.Builder> ... var1);
    }
}

