/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(CreateUserRequest.getter(CreateUserRequest::organizationId)).setter(CreateUserRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(CreateUserRequest.getter(CreateUserRequest::username)).setter(CreateUserRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(CreateUserRequest.getter(CreateUserRequest::emailAddress)).setter(CreateUserRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(CreateUserRequest.getter(CreateUserRequest::givenName)).setter(CreateUserRequest.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<String> SURNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Surname").getter(CreateUserRequest.getter(CreateUserRequest::surname)).setter(CreateUserRequest.setter(Builder::surname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(CreateUserRequest.getter(CreateUserRequest::password)).setter(CreateUserRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(CreateUserRequest.getter(CreateUserRequest::timeZoneId)).setter(CreateUserRequest.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<StorageRuleType> STORAGE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageRule").getter(CreateUserRequest.getter(CreateUserRequest::storageRule)).setter(CreateUserRequest.setter(Builder::storageRule)).constructor(StorageRuleType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageRule").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(CreateUserRequest.getter(CreateUserRequest::authenticationToken)).setter(CreateUserRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, USERNAME_FIELD, EMAIL_ADDRESS_FIELD, GIVEN_NAME_FIELD, SURNAME_FIELD, PASSWORD_FIELD, TIME_ZONE_ID_FIELD, STORAGE_RULE_FIELD, AUTHENTICATION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationId", ORGANIZATION_ID_FIELD);
            this.put("Username", USERNAME_FIELD);
            this.put("EmailAddress", EMAIL_ADDRESS_FIELD);
            this.put("GivenName", GIVEN_NAME_FIELD);
            this.put("Surname", SURNAME_FIELD);
            this.put("Password", PASSWORD_FIELD);
            this.put("TimeZoneId", TIME_ZONE_ID_FIELD);
            this.put("StorageRule", STORAGE_RULE_FIELD);
            this.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        }
    });
    private final String organizationId;
    private final String username;
    private final String emailAddress;
    private final String givenName;
    private final String surname;
    private final String password;
    private final String timeZoneId;
    private final StorageRuleType storageRule;
    private final String authenticationToken;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.username = builder.username;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.password = builder.password;
        this.timeZoneId = builder.timeZoneId;
        this.storageRule = builder.storageRule;
        this.authenticationToken = builder.authenticationToken;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String username() {
        return this.username;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final String surname() {
        return this.surname;
    }

    public final String password() {
        return this.password;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final StorageRuleType storageRule() {
        return this.storageRule;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.storageRule(), other.storageRule()) && Objects.equals(this.authenticationToken(), other.authenticationToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserRequest").add("OrganizationId", (Object)this.organizationId()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("GivenName", (Object)(this.givenName() == null ? null : "*** Sensitive Data Redacted ***")).add("Surname", (Object)(this.surname() == null ? null : "*** Sensitive Data Redacted ***")).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("TimeZoneId", (Object)this.timeZoneId()).add("StorageRule", (Object)this.storageRule()).add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "StorageRule": {
                return Optional.ofNullable(clazz.cast(this.storageRule()));
            }
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String username;
        private String emailAddress;
        private String givenName;
        private String surname;
        private String password;
        private String timeZoneId;
        private StorageRuleType storageRule;
        private String authenticationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.username(model.username);
            this.emailAddress(model.emailAddress);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.password(model.password);
            this.timeZoneId(model.timeZoneId);
            this.storageRule(model.storageRule);
            this.authenticationToken(model.authenticationToken);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSurname() {
            return this.surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return this.storageRule != null ? this.storageRule.toBuilder() : null;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder organizationId(String var1);

        public Builder username(String var1);

        public Builder emailAddress(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder password(String var1);

        public Builder timeZoneId(String var1);

        public Builder storageRule(StorageRuleType var1);

        default public Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return this.storageRule((StorageRuleType)((StorageRuleType.Builder)StorageRuleType.builder().applyMutation(storageRule)).build());
        }

        public Builder authenticationToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

