/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.SelectedProfileChoiceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileQuestionUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileQuestionUpdate> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(ProfileQuestionUpdate.getter(ProfileQuestionUpdate::questionId)).setter(ProfileQuestionUpdate.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoiceIds").getter(ProfileQuestionUpdate.getter(ProfileQuestionUpdate::selectedChoiceIds)).setter(ProfileQuestionUpdate.setter(Builder::selectedChoiceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoiceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, SELECTED_CHOICE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QuestionId", QUESTION_ID_FIELD);
            this.put("SelectedChoiceIds", SELECTED_CHOICE_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final List<String> selectedChoiceIds;

    private ProfileQuestionUpdate(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.selectedChoiceIds = builder.selectedChoiceIds;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final boolean hasSelectedChoiceIds() {
        return this.selectedChoiceIds != null && !(this.selectedChoiceIds instanceof SdkAutoConstructList);
    }

    public final List<String> selectedChoiceIds() {
        return this.selectedChoiceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoiceIds() ? this.selectedChoiceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQuestionUpdate)) {
            return false;
        }
        ProfileQuestionUpdate other = (ProfileQuestionUpdate)obj;
        return Objects.equals(this.questionId(), other.questionId()) && this.hasSelectedChoiceIds() == other.hasSelectedChoiceIds() && Objects.equals(this.selectedChoiceIds(), other.selectedChoiceIds());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileQuestionUpdate").add("QuestionId", (Object)this.questionId()).add("SelectedChoiceIds", this.hasSelectedChoiceIds() ? this.selectedChoiceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "SelectedChoiceIds": {
                return Optional.ofNullable(clazz.cast(this.selectedChoiceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProfileQuestionUpdate, T> g) {
        return obj -> g.apply((ProfileQuestionUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private List<String> selectedChoiceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileQuestionUpdate model) {
            this.questionId(model.questionId);
            this.selectedChoiceIds(model.selectedChoiceIds);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final Collection<String> getSelectedChoiceIds() {
            if (this.selectedChoiceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoiceIds;
        }

        public final void setSelectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedProfileChoiceIdsCopier.copy(selectedChoiceIds);
        }

        @Override
        public final Builder selectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedProfileChoiceIdsCopier.copy(selectedChoiceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoiceIds(String ... selectedChoiceIds) {
            this.selectedChoiceIds(Arrays.asList(selectedChoiceIds));
            return this;
        }

        public ProfileQuestionUpdate build() {
            return new ProfileQuestionUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileQuestionUpdate> {
        public Builder questionId(String var1);

        public Builder selectedChoiceIds(Collection<String> var1);

        public Builder selectedChoiceIds(String ... var1);
    }
}

