/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.LensStatus;
import software.amazon.awssdk.services.wellarchitected.model.LensType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensSummary> {
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(LensSummary.getter(LensSummary::lensArn)).setter(LensSummary.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensSummary.getter(LensSummary::lensAlias)).setter(LensSummary.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensName").getter(LensSummary.getter(LensSummary::lensName)).setter(LensSummary.setter(Builder::lensName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()}).build();
    private static final SdkField<String> LENS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensType").getter(LensSummary.getter(LensSummary::lensTypeAsString)).setter(LensSummary.setter(Builder::lensType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LensSummary.getter(LensSummary::description)).setter(LensSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(LensSummary.getter(LensSummary::createdAt)).setter(LensSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(LensSummary.getter(LensSummary::updatedAt)).setter(LensSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(LensSummary.getter(LensSummary::lensVersion)).setter(LensSummary.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(LensSummary.getter(LensSummary::owner)).setter(LensSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensStatus").getter(LensSummary.getter(LensSummary::lensStatusAsString)).setter(LensSummary.setter(Builder::lensStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ARN_FIELD, LENS_ALIAS_FIELD, LENS_NAME_FIELD, LENS_TYPE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LENS_VERSION_FIELD, OWNER_FIELD, LENS_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LensArn", LENS_ARN_FIELD);
            this.put("LensAlias", LENS_ALIAS_FIELD);
            this.put("LensName", LENS_NAME_FIELD);
            this.put("LensType", LENS_TYPE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
            this.put("LensVersion", LENS_VERSION_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("LensStatus", LENS_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String lensArn;
    private final String lensAlias;
    private final String lensName;
    private final String lensType;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String lensVersion;
    private final String owner;
    private final String lensStatus;

    private LensSummary(BuilderImpl builder) {
        this.lensArn = builder.lensArn;
        this.lensAlias = builder.lensAlias;
        this.lensName = builder.lensName;
        this.lensType = builder.lensType;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.lensVersion = builder.lensVersion;
        this.owner = builder.owner;
        this.lensStatus = builder.lensStatus;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensName() {
        return this.lensName;
    }

    public final LensType lensType() {
        return LensType.fromValue(this.lensType);
    }

    public final String lensTypeAsString() {
        return this.lensType;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    public final String owner() {
        return this.owner;
    }

    public final LensStatus lensStatus() {
        return LensStatus.fromValue(this.lensStatus);
    }

    public final String lensStatusAsString() {
        return this.lensStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensSummary)) {
            return false;
        }
        LensSummary other = (LensSummary)obj;
        return Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensName(), other.lensName()) && Objects.equals(this.lensTypeAsString(), other.lensTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.lensVersion(), other.lensVersion()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.lensStatusAsString(), other.lensStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LensSummary").add("LensArn", (Object)this.lensArn()).add("LensAlias", (Object)this.lensAlias()).add("LensName", (Object)this.lensName()).add("LensType", (Object)this.lensTypeAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("LensVersion", (Object)this.lensVersion()).add("Owner", (Object)this.owner()).add("LensStatus", (Object)this.lensStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensName": {
                return Optional.ofNullable(clazz.cast(this.lensName()));
            }
            case "LensType": {
                return Optional.ofNullable(clazz.cast(this.lensTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "LensStatus": {
                return Optional.ofNullable(clazz.cast(this.lensStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LensSummary, T> g) {
        return obj -> g.apply((LensSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensArn;
        private String lensAlias;
        private String lensName;
        private String lensType;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String lensVersion;
        private String owner;
        private String lensStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LensSummary model) {
            this.lensArn(model.lensArn);
            this.lensAlias(model.lensAlias);
            this.lensName(model.lensName);
            this.lensType(model.lensType);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.lensVersion(model.lensVersion);
            this.owner(model.owner);
            this.lensStatus(model.lensStatus);
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensName() {
            return this.lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensType() {
            return this.lensType;
        }

        public final void setLensType(String lensType) {
            this.lensType = lensType;
        }

        @Override
        public final Builder lensType(String lensType) {
            this.lensType = lensType;
            return this;
        }

        @Override
        public final Builder lensType(LensType lensType) {
            this.lensType(lensType == null ? null : lensType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getLensStatus() {
            return this.lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public LensSummary build() {
            return new LensSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensSummary> {
        public Builder lensArn(String var1);

        public Builder lensAlias(String var1);

        public Builder lensName(String var1);

        public Builder lensType(String var1);

        public Builder lensType(LensType var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder lensVersion(String var1);

        public Builder owner(String var1);

        public Builder lensStatus(String var1);

        public Builder lensStatus(LensStatus var1);
    }
}

