/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ConsolidatedReportMetric;
import software.amazon.awssdk.services.wellarchitected.model.ConsolidatedReportMetricsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConsolidatedReportResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, GetConsolidatedReportResponse> {
    private static final SdkField<List<ConsolidatedReportMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(GetConsolidatedReportResponse.getter(GetConsolidatedReportResponse::metrics)).setter(GetConsolidatedReportResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsolidatedReportMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetConsolidatedReportResponse.getter(GetConsolidatedReportResponse::nextToken)).setter(GetConsolidatedReportResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> BASE64_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Base64String").getter(GetConsolidatedReportResponse.getter(GetConsolidatedReportResponse::base64String)).setter(GetConsolidatedReportResponse.setter(Builder::base64String)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base64String").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, NEXT_TOKEN_FIELD, BASE64_STRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Metrics", METRICS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Base64String", BASE64_STRING_FIELD);
        }
    });
    private final List<ConsolidatedReportMetric> metrics;
    private final String nextToken;
    private final String base64String;

    private GetConsolidatedReportResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
        this.base64String = builder.base64String;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<ConsolidatedReportMetric> metrics() {
        return this.metrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String base64String() {
        return this.base64String;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.base64String());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsolidatedReportResponse)) {
            return false;
        }
        GetConsolidatedReportResponse other = (GetConsolidatedReportResponse)((Object)obj);
        return this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.base64String(), other.base64String());
    }

    public final String toString() {
        return ToString.builder((String)"GetConsolidatedReportResponse").add("Metrics", this.hasMetrics() ? this.metrics() : null).add("NextToken", (Object)this.nextToken()).add("Base64String", (Object)this.base64String()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Base64String": {
                return Optional.ofNullable(clazz.cast(this.base64String()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConsolidatedReportResponse, T> g) {
        return obj -> g.apply((GetConsolidatedReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<ConsolidatedReportMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String base64String;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsolidatedReportResponse model) {
            super(model);
            this.metrics(model.metrics);
            this.nextToken(model.nextToken);
            this.base64String(model.base64String);
        }

        public final List<ConsolidatedReportMetric.Builder> getMetrics() {
            List<ConsolidatedReportMetric.Builder> result = ConsolidatedReportMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<ConsolidatedReportMetric.BuilderImpl> metrics) {
            this.metrics = ConsolidatedReportMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<ConsolidatedReportMetric> metrics) {
            this.metrics = ConsolidatedReportMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(ConsolidatedReportMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<ConsolidatedReportMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (ConsolidatedReportMetric)((ConsolidatedReportMetric.Builder)ConsolidatedReportMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getBase64String() {
            return this.base64String;
        }

        public final void setBase64String(String base64String) {
            this.base64String = base64String;
        }

        @Override
        public final Builder base64String(String base64String) {
            this.base64String = base64String;
            return this;
        }

        @Override
        public GetConsolidatedReportResponse build() {
            return new GetConsolidatedReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConsolidatedReportResponse> {
        public Builder metrics(Collection<ConsolidatedReportMetric> var1);

        public Builder metrics(ConsolidatedReportMetric ... var1);

        public Builder metrics(Consumer<ConsolidatedReportMetric.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder base64String(String var1);
    }
}

