/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContains;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionHeader;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionJson;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseInspection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseInspection> {
    private static final SdkField<ResponseInspectionStatusCode> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusCode").getter(ResponseInspection.getter(ResponseInspection::statusCode)).setter(ResponseInspection.setter(Builder::statusCode)).constructor(ResponseInspectionStatusCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<ResponseInspectionHeader> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Header").getter(ResponseInspection.getter(ResponseInspection::header)).setter(ResponseInspection.setter(Builder::header)).constructor(ResponseInspectionHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()}).build();
    private static final SdkField<ResponseInspectionBodyContains> BODY_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BodyContains").getter(ResponseInspection.getter(ResponseInspection::bodyContains)).setter(ResponseInspection.setter(Builder::bodyContains)).constructor(ResponseInspectionBodyContains::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyContains").build()}).build();
    private static final SdkField<ResponseInspectionJson> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Json").getter(ResponseInspection.getter(ResponseInspection::json)).setter(ResponseInspection.setter(Builder::json)).constructor(ResponseInspectionJson::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Json").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, HEADER_FIELD, BODY_CONTAINS_FIELD, JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StatusCode", STATUS_CODE_FIELD);
            this.put("Header", HEADER_FIELD);
            this.put("BodyContains", BODY_CONTAINS_FIELD);
            this.put("Json", JSON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ResponseInspectionStatusCode statusCode;
    private final ResponseInspectionHeader header;
    private final ResponseInspectionBodyContains bodyContains;
    private final ResponseInspectionJson json;

    private ResponseInspection(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.header = builder.header;
        this.bodyContains = builder.bodyContains;
        this.json = builder.json;
    }

    public final ResponseInspectionStatusCode statusCode() {
        return this.statusCode;
    }

    public final ResponseInspectionHeader header() {
        return this.header;
    }

    public final ResponseInspectionBodyContains bodyContains() {
        return this.bodyContains;
    }

    public final ResponseInspectionJson json() {
        return this.json;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        hashCode = 31 * hashCode + Objects.hashCode(this.bodyContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.json());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspection)) {
            return false;
        }
        ResponseInspection other = (ResponseInspection)obj;
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.header(), other.header()) && Objects.equals(this.bodyContains(), other.bodyContains()) && Objects.equals(this.json(), other.json());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseInspection").add("StatusCode", (Object)this.statusCode()).add("Header", (Object)this.header()).add("BodyContains", (Object)this.bodyContains()).add("Json", (Object)this.json()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "BodyContains": {
                return Optional.ofNullable(clazz.cast(this.bodyContains()));
            }
            case "Json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResponseInspection, T> g) {
        return obj -> g.apply((ResponseInspection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResponseInspectionStatusCode statusCode;
        private ResponseInspectionHeader header;
        private ResponseInspectionBodyContains bodyContains;
        private ResponseInspectionJson json;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseInspection model) {
            this.statusCode(model.statusCode);
            this.header(model.header);
            this.bodyContains(model.bodyContains);
            this.json(model.json);
        }

        public final ResponseInspectionStatusCode.Builder getStatusCode() {
            return this.statusCode != null ? this.statusCode.toBuilder() : null;
        }

        public final void setStatusCode(ResponseInspectionStatusCode.BuilderImpl statusCode) {
            this.statusCode = statusCode != null ? statusCode.build() : null;
        }

        @Override
        public final Builder statusCode(ResponseInspectionStatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final ResponseInspectionHeader.Builder getHeader() {
            return this.header != null ? this.header.toBuilder() : null;
        }

        public final void setHeader(ResponseInspectionHeader.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        public final Builder header(ResponseInspectionHeader header) {
            this.header = header;
            return this;
        }

        public final ResponseInspectionBodyContains.Builder getBodyContains() {
            return this.bodyContains != null ? this.bodyContains.toBuilder() : null;
        }

        public final void setBodyContains(ResponseInspectionBodyContains.BuilderImpl bodyContains) {
            this.bodyContains = bodyContains != null ? bodyContains.build() : null;
        }

        @Override
        public final Builder bodyContains(ResponseInspectionBodyContains bodyContains) {
            this.bodyContains = bodyContains;
            return this;
        }

        public final ResponseInspectionJson.Builder getJson() {
            return this.json != null ? this.json.toBuilder() : null;
        }

        public final void setJson(ResponseInspectionJson.BuilderImpl json) {
            this.json = json != null ? json.build() : null;
        }

        @Override
        public final Builder json(ResponseInspectionJson json) {
            this.json = json;
            return this;
        }

        public ResponseInspection build() {
            return new ResponseInspection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseInspection> {
        public Builder statusCode(ResponseInspectionStatusCode var1);

        default public Builder statusCode(Consumer<ResponseInspectionStatusCode.Builder> statusCode) {
            return this.statusCode((ResponseInspectionStatusCode)((ResponseInspectionStatusCode.Builder)ResponseInspectionStatusCode.builder().applyMutation(statusCode)).build());
        }

        public Builder header(ResponseInspectionHeader var1);

        default public Builder header(Consumer<ResponseInspectionHeader.Builder> header) {
            return this.header((ResponseInspectionHeader)((ResponseInspectionHeader.Builder)ResponseInspectionHeader.builder().applyMutation(header)).build());
        }

        public Builder bodyContains(ResponseInspectionBodyContains var1);

        default public Builder bodyContains(Consumer<ResponseInspectionBodyContains.Builder> bodyContains) {
            return this.bodyContains((ResponseInspectionBodyContains)((ResponseInspectionBodyContains.Builder)ResponseInspectionBodyContains.builder().applyMutation(bodyContains)).build());
        }

        public Builder json(ResponseInspectionJson var1);

        default public Builder json(Consumer<ResponseInspectionJson.Builder> json) {
            return this.json((ResponseInspectionJson)((ResponseInspectionJson.Builder)ResponseInspectionJson.builder().applyMutation(json)).build());
        }
    }
}

