/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType;
import software.amazon.awssdk.services.transcribe.model.OutputLocationType;
import software.amazon.awssdk.services.transcribe.model.Specialty;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.services.transcribe.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalTranscriptionJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalTranscriptionJobSummary> {
    private static final SdkField<String> MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalTranscriptionJobName").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::medicalTranscriptionJobName)).setter(MedicalTranscriptionJobSummary.setter(Builder::medicalTranscriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::creationTime)).setter(MedicalTranscriptionJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::startTime)).setter(MedicalTranscriptionJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::completionTime)).setter(MedicalTranscriptionJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::languageCodeAsString)).setter(MedicalTranscriptionJobSummary.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobStatus").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::transcriptionJobStatusAsString)).setter(MedicalTranscriptionJobSummary.setter(Builder::transcriptionJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::failureReason)).setter(MedicalTranscriptionJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> OUTPUT_LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocationType").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::outputLocationTypeAsString)).setter(MedicalTranscriptionJobSummary.setter(Builder::outputLocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocationType").build()}).build();
    private static final SdkField<String> SPECIALTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Specialty").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::specialtyAsString)).setter(MedicalTranscriptionJobSummary.setter(Builder::specialty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::contentIdentificationTypeAsString)).setter(MedicalTranscriptionJobSummary.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(MedicalTranscriptionJobSummary.getter(MedicalTranscriptionJobSummary::typeAsString)).setter(MedicalTranscriptionJobSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, OUTPUT_LOCATION_TYPE_FIELD, SPECIALTY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MedicalTranscriptionJobName", MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("CompletionTime", COMPLETION_TIME_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("TranscriptionJobStatus", TRANSCRIPTION_JOB_STATUS_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("OutputLocationType", OUTPUT_LOCATION_TYPE_FIELD);
            this.put("Specialty", SPECIALTY_FIELD);
            this.put("ContentIdentificationType", CONTENT_IDENTIFICATION_TYPE_FIELD);
            this.put("Type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String medicalTranscriptionJobName;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant completionTime;
    private final String languageCode;
    private final String transcriptionJobStatus;
    private final String failureReason;
    private final String outputLocationType;
    private final String specialty;
    private final String contentIdentificationType;
    private final String type;

    private MedicalTranscriptionJobSummary(BuilderImpl builder) {
        this.medicalTranscriptionJobName = builder.medicalTranscriptionJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.failureReason = builder.failureReason;
        this.outputLocationType = builder.outputLocationType;
        this.specialty = builder.specialty;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.type = builder.type;
    }

    public final String medicalTranscriptionJobName() {
        return this.medicalTranscriptionJobName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(this.transcriptionJobStatus);
    }

    public final String transcriptionJobStatusAsString() {
        return this.transcriptionJobStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final OutputLocationType outputLocationType() {
        return OutputLocationType.fromValue(this.outputLocationType);
    }

    public final String outputLocationTypeAsString() {
        return this.outputLocationType;
    }

    public final Specialty specialty() {
        return Specialty.fromValue(this.specialty);
    }

    public final String specialtyAsString() {
        return this.specialty;
    }

    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalTranscriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscriptionJobSummary)) {
            return false;
        }
        MedicalTranscriptionJobSummary other = (MedicalTranscriptionJobSummary)obj;
        return Objects.equals(this.medicalTranscriptionJobName(), other.medicalTranscriptionJobName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.outputLocationTypeAsString(), other.outputLocationTypeAsString()) && Objects.equals(this.specialtyAsString(), other.specialtyAsString()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalTranscriptionJobSummary").add("MedicalTranscriptionJobName", (Object)this.medicalTranscriptionJobName()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("CompletionTime", (Object)this.completionTime()).add("LanguageCode", (Object)this.languageCodeAsString()).add("TranscriptionJobStatus", (Object)this.transcriptionJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("OutputLocationType", (Object)this.outputLocationTypeAsString()).add("Specialty", (Object)this.specialtyAsString()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MedicalTranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.medicalTranscriptionJobName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "TranscriptionJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "OutputLocationType": {
                return Optional.ofNullable(clazz.cast(this.outputLocationTypeAsString()));
            }
            case "Specialty": {
                return Optional.ofNullable(clazz.cast(this.specialtyAsString()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscriptionJobSummary, T> g) {
        return obj -> g.apply((MedicalTranscriptionJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String medicalTranscriptionJobName;
        private Instant creationTime;
        private Instant startTime;
        private Instant completionTime;
        private String languageCode;
        private String transcriptionJobStatus;
        private String failureReason;
        private String outputLocationType;
        private String specialty;
        private String contentIdentificationType;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscriptionJobSummary model) {
            this.medicalTranscriptionJobName(model.medicalTranscriptionJobName);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.completionTime(model.completionTime);
            this.languageCode(model.languageCode);
            this.transcriptionJobStatus(model.transcriptionJobStatus);
            this.failureReason(model.failureReason);
            this.outputLocationType(model.outputLocationType);
            this.specialty(model.specialty);
            this.contentIdentificationType(model.contentIdentificationType);
            this.type(model.type);
        }

        public final String getMedicalTranscriptionJobName() {
            return this.medicalTranscriptionJobName;
        }

        public final void setMedicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
        }

        @Override
        public final Builder medicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getTranscriptionJobStatus() {
            return this.transcriptionJobStatus;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getOutputLocationType() {
            return this.outputLocationType;
        }

        public final void setOutputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
        }

        @Override
        public final Builder outputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
            return this;
        }

        @Override
        public final Builder outputLocationType(OutputLocationType outputLocationType) {
            this.outputLocationType(outputLocationType == null ? null : outputLocationType.toString());
            return this;
        }

        public final String getSpecialty() {
            return this.specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public MedicalTranscriptionJobSummary build() {
            return new MedicalTranscriptionJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalTranscriptionJobSummary> {
        public Builder medicalTranscriptionJobName(String var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder transcriptionJobStatus(String var1);

        public Builder transcriptionJobStatus(TranscriptionJobStatus var1);

        public Builder failureReason(String var1);

        public Builder outputLocationType(String var1);

        public Builder outputLocationType(OutputLocationType var1);

        public Builder specialty(String var1);

        public Builder specialty(Specialty var1);

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(MedicalContentIdentificationType var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

