/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Adapter;
import software.amazon.awssdk.services.textract.model.AdaptersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdaptersConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdaptersConfig> {
    private static final SdkField<List<Adapter>> ADAPTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Adapters").getter(AdaptersConfig.getter(AdaptersConfig::adapters)).setter(AdaptersConfig.setter(Builder::adapters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adapters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Adapter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Adapters", ADAPTERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Adapter> adapters;

    private AdaptersConfig(BuilderImpl builder) {
        this.adapters = builder.adapters;
    }

    public final boolean hasAdapters() {
        return this.adapters != null && !(this.adapters instanceof SdkAutoConstructList);
    }

    public final List<Adapter> adapters() {
        return this.adapters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdapters() ? this.adapters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdaptersConfig)) {
            return false;
        }
        AdaptersConfig other = (AdaptersConfig)obj;
        return this.hasAdapters() == other.hasAdapters() && Objects.equals(this.adapters(), other.adapters());
    }

    public final String toString() {
        return ToString.builder((String)"AdaptersConfig").add("Adapters", this.hasAdapters() ? this.adapters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Adapters": {
                return Optional.ofNullable(clazz.cast(this.adapters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdaptersConfig, T> g) {
        return obj -> g.apply((AdaptersConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Adapter> adapters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdaptersConfig model) {
            this.adapters(model.adapters);
        }

        public final List<Adapter.Builder> getAdapters() {
            List<Adapter.Builder> result = AdaptersCopier.copyToBuilder(this.adapters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdapters(Collection<Adapter.BuilderImpl> adapters) {
            this.adapters = AdaptersCopier.copyFromBuilder(adapters);
        }

        @Override
        public final Builder adapters(Collection<Adapter> adapters) {
            this.adapters = AdaptersCopier.copy(adapters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapters(Adapter ... adapters) {
            this.adapters(Arrays.asList(adapters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapters(Consumer<Adapter.Builder> ... adapters) {
            this.adapters(Stream.of(adapters).map(c -> (Adapter)((Adapter.Builder)Adapter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AdaptersConfig build() {
            return new AdaptersConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdaptersConfig> {
        public Builder adapters(Collection<Adapter> var1);

        public Builder adapters(Adapter ... var1);

        public Builder adapters(Consumer<Adapter.Builder> ... var1);
    }
}

