/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkflowExecutionResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, DescribeWorkflowExecutionResponse> {
    private static final SdkField<WorkflowExecutionInfo> EXECUTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionInfo").getter(DescribeWorkflowExecutionResponse.getter(DescribeWorkflowExecutionResponse::executionInfo)).setter(DescribeWorkflowExecutionResponse.setter(Builder::executionInfo)).constructor(WorkflowExecutionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfo").build()}).build();
    private static final SdkField<WorkflowExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionConfiguration").getter(DescribeWorkflowExecutionResponse.getter(DescribeWorkflowExecutionResponse::executionConfiguration)).setter(DescribeWorkflowExecutionResponse.setter(Builder::executionConfiguration)).constructor(WorkflowExecutionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionConfiguration").build()}).build();
    private static final SdkField<WorkflowExecutionOpenCounts> OPEN_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openCounts").getter(DescribeWorkflowExecutionResponse.getter(DescribeWorkflowExecutionResponse::openCounts)).setter(DescribeWorkflowExecutionResponse.setter(Builder::openCounts)).constructor(WorkflowExecutionOpenCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openCounts").build()}).build();
    private static final SdkField<Instant> LATEST_ACTIVITY_TASK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("latestActivityTaskTimestamp").getter(DescribeWorkflowExecutionResponse.getter(DescribeWorkflowExecutionResponse::latestActivityTaskTimestamp)).setter(DescribeWorkflowExecutionResponse.setter(Builder::latestActivityTaskTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestActivityTaskTimestamp").build()}).build();
    private static final SdkField<String> LATEST_EXECUTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestExecutionContext").getter(DescribeWorkflowExecutionResponse.getter(DescribeWorkflowExecutionResponse::latestExecutionContext)).setter(DescribeWorkflowExecutionResponse.setter(Builder::latestExecutionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecutionContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_INFO_FIELD, EXECUTION_CONFIGURATION_FIELD, OPEN_COUNTS_FIELD, LATEST_ACTIVITY_TASK_TIMESTAMP_FIELD, LATEST_EXECUTION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("executionInfo", EXECUTION_INFO_FIELD);
            this.put("executionConfiguration", EXECUTION_CONFIGURATION_FIELD);
            this.put("openCounts", OPEN_COUNTS_FIELD);
            this.put("latestActivityTaskTimestamp", LATEST_ACTIVITY_TASK_TIMESTAMP_FIELD);
            this.put("latestExecutionContext", LATEST_EXECUTION_CONTEXT_FIELD);
        }
    });
    private final WorkflowExecutionInfo executionInfo;
    private final WorkflowExecutionConfiguration executionConfiguration;
    private final WorkflowExecutionOpenCounts openCounts;
    private final Instant latestActivityTaskTimestamp;
    private final String latestExecutionContext;

    private DescribeWorkflowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionInfo = builder.executionInfo;
        this.executionConfiguration = builder.executionConfiguration;
        this.openCounts = builder.openCounts;
        this.latestActivityTaskTimestamp = builder.latestActivityTaskTimestamp;
        this.latestExecutionContext = builder.latestExecutionContext;
    }

    public final WorkflowExecutionInfo executionInfo() {
        return this.executionInfo;
    }

    public final WorkflowExecutionConfiguration executionConfiguration() {
        return this.executionConfiguration;
    }

    public final WorkflowExecutionOpenCounts openCounts() {
        return this.openCounts;
    }

    public final Instant latestActivityTaskTimestamp() {
        return this.latestActivityTaskTimestamp;
    }

    public final String latestExecutionContext() {
        return this.latestExecutionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.openCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestActivityTaskTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecutionContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionResponse)) {
            return false;
        }
        DescribeWorkflowExecutionResponse other = (DescribeWorkflowExecutionResponse)((Object)obj);
        return Objects.equals(this.executionInfo(), other.executionInfo()) && Objects.equals(this.executionConfiguration(), other.executionConfiguration()) && Objects.equals(this.openCounts(), other.openCounts()) && Objects.equals(this.latestActivityTaskTimestamp(), other.latestActivityTaskTimestamp()) && Objects.equals(this.latestExecutionContext(), other.latestExecutionContext());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkflowExecutionResponse").add("ExecutionInfo", (Object)this.executionInfo()).add("ExecutionConfiguration", (Object)this.executionConfiguration()).add("OpenCounts", (Object)this.openCounts()).add("LatestActivityTaskTimestamp", (Object)this.latestActivityTaskTimestamp()).add("LatestExecutionContext", (Object)this.latestExecutionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionInfo": {
                return Optional.ofNullable(clazz.cast(this.executionInfo()));
            }
            case "executionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.executionConfiguration()));
            }
            case "openCounts": {
                return Optional.ofNullable(clazz.cast(this.openCounts()));
            }
            case "latestActivityTaskTimestamp": {
                return Optional.ofNullable(clazz.cast(this.latestActivityTaskTimestamp()));
            }
            case "latestExecutionContext": {
                return Optional.ofNullable(clazz.cast(this.latestExecutionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowExecutionResponse, T> g) {
        return obj -> g.apply((DescribeWorkflowExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private WorkflowExecutionInfo executionInfo;
        private WorkflowExecutionConfiguration executionConfiguration;
        private WorkflowExecutionOpenCounts openCounts;
        private Instant latestActivityTaskTimestamp;
        private String latestExecutionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionResponse model) {
            super(model);
            this.executionInfo(model.executionInfo);
            this.executionConfiguration(model.executionConfiguration);
            this.openCounts(model.openCounts);
            this.latestActivityTaskTimestamp(model.latestActivityTaskTimestamp);
            this.latestExecutionContext(model.latestExecutionContext);
        }

        public final WorkflowExecutionInfo.Builder getExecutionInfo() {
            return this.executionInfo != null ? this.executionInfo.toBuilder() : null;
        }

        public final void setExecutionInfo(WorkflowExecutionInfo.BuilderImpl executionInfo) {
            this.executionInfo = executionInfo != null ? executionInfo.build() : null;
        }

        @Override
        public final Builder executionInfo(WorkflowExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final WorkflowExecutionConfiguration.Builder getExecutionConfiguration() {
            return this.executionConfiguration != null ? this.executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(WorkflowExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(WorkflowExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final WorkflowExecutionOpenCounts.Builder getOpenCounts() {
            return this.openCounts != null ? this.openCounts.toBuilder() : null;
        }

        public final void setOpenCounts(WorkflowExecutionOpenCounts.BuilderImpl openCounts) {
            this.openCounts = openCounts != null ? openCounts.build() : null;
        }

        @Override
        public final Builder openCounts(WorkflowExecutionOpenCounts openCounts) {
            this.openCounts = openCounts;
            return this;
        }

        public final Instant getLatestActivityTaskTimestamp() {
            return this.latestActivityTaskTimestamp;
        }

        public final void setLatestActivityTaskTimestamp(Instant latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = latestActivityTaskTimestamp;
        }

        @Override
        public final Builder latestActivityTaskTimestamp(Instant latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = latestActivityTaskTimestamp;
            return this;
        }

        public final String getLatestExecutionContext() {
            return this.latestExecutionContext;
        }

        public final void setLatestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
        }

        @Override
        public final Builder latestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
            return this;
        }

        @Override
        public DescribeWorkflowExecutionResponse build() {
            return new DescribeWorkflowExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkflowExecutionResponse> {
        public Builder executionInfo(WorkflowExecutionInfo var1);

        default public Builder executionInfo(Consumer<WorkflowExecutionInfo.Builder> executionInfo) {
            return this.executionInfo((WorkflowExecutionInfo)((WorkflowExecutionInfo.Builder)WorkflowExecutionInfo.builder().applyMutation(executionInfo)).build());
        }

        public Builder executionConfiguration(WorkflowExecutionConfiguration var1);

        default public Builder executionConfiguration(Consumer<WorkflowExecutionConfiguration.Builder> executionConfiguration) {
            return this.executionConfiguration((WorkflowExecutionConfiguration)((WorkflowExecutionConfiguration.Builder)WorkflowExecutionConfiguration.builder().applyMutation(executionConfiguration)).build());
        }

        public Builder openCounts(WorkflowExecutionOpenCounts var1);

        default public Builder openCounts(Consumer<WorkflowExecutionOpenCounts.Builder> openCounts) {
            return this.openCounts((WorkflowExecutionOpenCounts)((WorkflowExecutionOpenCounts.Builder)WorkflowExecutionOpenCounts.builder().applyMutation(openCounts)).build());
        }

        public Builder latestActivityTaskTimestamp(Instant var1);

        public Builder latestExecutionContext(String var1);
    }
}

