/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supportapp.SupportAppAsyncClient;
import software.amazon.awssdk.services.supportapp.internal.UserAgentUtils;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse;

public class ListSlackWorkspaceConfigurationsPublisher
implements SdkPublisher<ListSlackWorkspaceConfigurationsResponse> {
    private final SupportAppAsyncClient client;
    private final ListSlackWorkspaceConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSlackWorkspaceConfigurationsPublisher(SupportAppAsyncClient client, ListSlackWorkspaceConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSlackWorkspaceConfigurationsPublisher(SupportAppAsyncClient client, ListSlackWorkspaceConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSlackWorkspaceConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSlackWorkspaceConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSlackWorkspaceConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListSlackWorkspaceConfigurationsResponse> {
        private ListSlackWorkspaceConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSlackWorkspaceConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSlackWorkspaceConfigurationsResponse> nextPage(ListSlackWorkspaceConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSlackWorkspaceConfigurationsPublisher.this.client.listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsPublisher.this.firstRequest);
            }
            return ListSlackWorkspaceConfigurationsPublisher.this.client.listSlackWorkspaceConfigurations((ListSlackWorkspaceConfigurationsRequest)((Object)ListSlackWorkspaceConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

