/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.GatewayInfo;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse;

public class ListGatewaysIterable
implements SdkIterable<ListGatewaysResponse> {
    private final StorageGatewayClient client;
    private final ListGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewaysIterable(StorageGatewayClient client, ListGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGatewaysResponseFetcher();
    }

    public Iterator<ListGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GatewayInfo> gateways() {
        Function<ListGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gateways() != null) {
                return response.gateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGatewaysResponseFetcher
    implements SyncPageFetcher<ListGatewaysResponse> {
        private ListGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListGatewaysResponse nextPage(ListGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListGatewaysIterable.this.client.listGateways(ListGatewaysIterable.this.firstRequest);
            }
            return ListGatewaysIterable.this.client.listGateways((ListGatewaysRequest)((Object)ListGatewaysIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

