/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.AllocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAddressMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAddressMember> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(IpAddressMember.getter(IpAddressMember::ipAddress)).setter(IpAddressMember.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Primary").getter(IpAddressMember.getter(IpAddressMember::primary)).setter(IpAddressMember.setter(Builder::primary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()}).build();
    private static final SdkField<String> ALLOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationType").getter(IpAddressMember.getter(IpAddressMember::allocationTypeAsString)).setter(IpAddressMember.setter(Builder::allocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, PRIMARY_FIELD, ALLOCATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IpAddress", IP_ADDRESS_FIELD);
            this.put("Primary", PRIMARY_FIELD);
            this.put("AllocationType", ALLOCATION_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ipAddress;
    private final Boolean primary;
    private final String allocationType;

    private IpAddressMember(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.primary = builder.primary;
        this.allocationType = builder.allocationType;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final Boolean primary() {
        return this.primary;
    }

    public final AllocationType allocationType() {
        return AllocationType.fromValue(this.allocationType);
    }

    public final String allocationTypeAsString() {
        return this.allocationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressMember)) {
            return false;
        }
        IpAddressMember other = (IpAddressMember)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.primary(), other.primary()) && Objects.equals(this.allocationTypeAsString(), other.allocationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IpAddressMember").add("IpAddress", (Object)this.ipAddress()).add("Primary", (Object)this.primary()).add("AllocationType", (Object)this.allocationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "Primary": {
                return Optional.ofNullable(clazz.cast(this.primary()));
            }
            case "AllocationType": {
                return Optional.ofNullable(clazz.cast(this.allocationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpAddressMember, T> g) {
        return obj -> g.apply((IpAddressMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private Boolean primary;
        private String allocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressMember model) {
            this.ipAddress(model.ipAddress);
            this.primary(model.primary);
            this.allocationType(model.allocationType);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final String getAllocationType() {
            return this.allocationType;
        }

        public final void setAllocationType(String allocationType) {
            this.allocationType = allocationType;
        }

        @Override
        public final Builder allocationType(String allocationType) {
            this.allocationType = allocationType;
            return this;
        }

        @Override
        public final Builder allocationType(AllocationType allocationType) {
            this.allocationType(allocationType == null ? null : allocationType.toString());
            return this;
        }

        public IpAddressMember build() {
            return new IpAddressMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAddressMember> {
        public Builder ipAddress(String var1);

        public Builder primary(Boolean var1);

        public Builder allocationType(String var1);

        public Builder allocationType(AllocationType var1);
    }
}

