/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ApplicationCredential;
import software.amazon.awssdk.services.ssmsap.model.ApplicationCredentialListCopier;
import software.amazon.awssdk.services.ssmsap.model.ComponentArnListCopier;
import software.amazon.awssdk.services.ssmsap.model.DatabaseStatus;
import software.amazon.awssdk.services.ssmsap.model.DatabaseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Database
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Database> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(Database.getter(Database::applicationId)).setter(Database.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(Database.getter(Database::componentId)).setter(Database.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()}).build();
    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Credentials").getter(Database.getter(Database::credentials)).setter(Database.setter(Builder::credentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseId").getter(Database.getter(Database::databaseId)).setter(Database.setter(Builder::databaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(Database.getter(Database::databaseName)).setter(Database.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DATABASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseType").getter(Database.getter(Database::databaseTypeAsString)).setter(Database.setter(Builder::databaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseType").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Database.getter(Database::arn)).setter(Database.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Database.getter(Database::statusAsString)).setter(Database.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PRIMARY_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryHost").getter(Database.getter(Database::primaryHost)).setter(Database.setter(Builder::primaryHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryHost").build()}).build();
    private static final SdkField<Integer> SQL_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SQLPort").getter(Database.getter(Database::sqlPort)).setter(Database.setter(Builder::sqlPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SQLPort").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(Database.getter(Database::lastUpdated)).setter(Database.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<List<String>> CONNECTED_COMPONENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectedComponentArns").getter(Database.getter(Database::connectedComponentArns)).setter(Database.setter(Builder::connectedComponentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedComponentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, COMPONENT_ID_FIELD, CREDENTIALS_FIELD, DATABASE_ID_FIELD, DATABASE_NAME_FIELD, DATABASE_TYPE_FIELD, ARN_FIELD, STATUS_FIELD, PRIMARY_HOST_FIELD, SQL_PORT_FIELD, LAST_UPDATED_FIELD, CONNECTED_COMPONENT_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationId", APPLICATION_ID_FIELD);
            this.put("ComponentId", COMPONENT_ID_FIELD);
            this.put("Credentials", CREDENTIALS_FIELD);
            this.put("DatabaseId", DATABASE_ID_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("DatabaseType", DATABASE_TYPE_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("PrimaryHost", PRIMARY_HOST_FIELD);
            this.put("SQLPort", SQL_PORT_FIELD);
            this.put("LastUpdated", LAST_UPDATED_FIELD);
            this.put("ConnectedComponentArns", CONNECTED_COMPONENT_ARNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String componentId;
    private final List<ApplicationCredential> credentials;
    private final String databaseId;
    private final String databaseName;
    private final String databaseType;
    private final String arn;
    private final String status;
    private final String primaryHost;
    private final Integer sqlPort;
    private final Instant lastUpdated;
    private final List<String> connectedComponentArns;

    private Database(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.componentId = builder.componentId;
        this.credentials = builder.credentials;
        this.databaseId = builder.databaseId;
        this.databaseName = builder.databaseName;
        this.databaseType = builder.databaseType;
        this.arn = builder.arn;
        this.status = builder.status;
        this.primaryHost = builder.primaryHost;
        this.sqlPort = builder.sqlPort;
        this.lastUpdated = builder.lastUpdated;
        this.connectedComponentArns = builder.connectedComponentArns;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final boolean hasCredentials() {
        return this.credentials != null && !(this.credentials instanceof SdkAutoConstructList);
    }

    public final List<ApplicationCredential> credentials() {
        return this.credentials;
    }

    public final String databaseId() {
        return this.databaseId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final DatabaseType databaseType() {
        return DatabaseType.fromValue(this.databaseType);
    }

    public final String databaseTypeAsString() {
        return this.databaseType;
    }

    public final String arn() {
        return this.arn;
    }

    public final DatabaseStatus status() {
        return DatabaseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String primaryHost() {
        return this.primaryHost;
    }

    public final Integer sqlPort() {
        return this.sqlPort;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final boolean hasConnectedComponentArns() {
        return this.connectedComponentArns != null && !(this.connectedComponentArns instanceof SdkAutoConstructList);
    }

    public final List<String> connectedComponentArns() {
        return this.connectedComponentArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentials() ? this.credentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryHost());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectedComponentArns() ? this.connectedComponentArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Database)) {
            return false;
        }
        Database other = (Database)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.componentId(), other.componentId()) && this.hasCredentials() == other.hasCredentials() && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.databaseId(), other.databaseId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.databaseTypeAsString(), other.databaseTypeAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.primaryHost(), other.primaryHost()) && Objects.equals(this.sqlPort(), other.sqlPort()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && this.hasConnectedComponentArns() == other.hasConnectedComponentArns() && Objects.equals(this.connectedComponentArns(), other.connectedComponentArns());
    }

    public final String toString() {
        return ToString.builder((String)"Database").add("ApplicationId", (Object)this.applicationId()).add("ComponentId", (Object)this.componentId()).add("Credentials", this.hasCredentials() ? this.credentials() : null).add("DatabaseId", (Object)this.databaseId()).add("DatabaseName", (Object)this.databaseName()).add("DatabaseType", (Object)this.databaseTypeAsString()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("PrimaryHost", (Object)this.primaryHost()).add("SQLPort", (Object)this.sqlPort()).add("LastUpdated", (Object)this.lastUpdated()).add("ConnectedComponentArns", this.hasConnectedComponentArns() ? this.connectedComponentArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "DatabaseId": {
                return Optional.ofNullable(clazz.cast(this.databaseId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DatabaseType": {
                return Optional.ofNullable(clazz.cast(this.databaseTypeAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "PrimaryHost": {
                return Optional.ofNullable(clazz.cast(this.primaryHost()));
            }
            case "SQLPort": {
                return Optional.ofNullable(clazz.cast(this.sqlPort()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "ConnectedComponentArns": {
                return Optional.ofNullable(clazz.cast(this.connectedComponentArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Database, T> g) {
        return obj -> g.apply((Database)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String componentId;
        private List<ApplicationCredential> credentials = DefaultSdkAutoConstructList.getInstance();
        private String databaseId;
        private String databaseName;
        private String databaseType;
        private String arn;
        private String status;
        private String primaryHost;
        private Integer sqlPort;
        private Instant lastUpdated;
        private List<String> connectedComponentArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Database model) {
            this.applicationId(model.applicationId);
            this.componentId(model.componentId);
            this.credentials(model.credentials);
            this.databaseId(model.databaseId);
            this.databaseName(model.databaseName);
            this.databaseType(model.databaseType);
            this.arn(model.arn);
            this.status(model.status);
            this.primaryHost(model.primaryHost);
            this.sqlPort(model.sqlPort);
            this.lastUpdated(model.lastUpdated);
            this.connectedComponentArns(model.connectedComponentArns);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentials() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<ApplicationCredential.BuilderImpl> credentials) {
            this.credentials = ApplicationCredentialListCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<ApplicationCredential> credentials) {
            this.credentials = ApplicationCredentialListCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(ApplicationCredential ... credentials) {
            this.credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<ApplicationCredential.Builder> ... credentials) {
            this.credentials(Stream.of(credentials).map(c -> (ApplicationCredential)((ApplicationCredential.Builder)ApplicationCredential.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDatabaseId() {
            return this.databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDatabaseType() {
            return this.databaseType;
        }

        public final void setDatabaseType(String databaseType) {
            this.databaseType = databaseType;
        }

        @Override
        public final Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        @Override
        public final Builder databaseType(DatabaseType databaseType) {
            this.databaseType(databaseType == null ? null : databaseType.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatabaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPrimaryHost() {
            return this.primaryHost;
        }

        public final void setPrimaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
        }

        @Override
        public final Builder primaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
            return this;
        }

        public final Integer getSqlPort() {
            return this.sqlPort;
        }

        public final void setSqlPort(Integer sqlPort) {
            this.sqlPort = sqlPort;
        }

        @Override
        public final Builder sqlPort(Integer sqlPort) {
            this.sqlPort = sqlPort;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Collection<String> getConnectedComponentArns() {
            if (this.connectedComponentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectedComponentArns;
        }

        public final void setConnectedComponentArns(Collection<String> connectedComponentArns) {
            this.connectedComponentArns = ComponentArnListCopier.copy(connectedComponentArns);
        }

        @Override
        public final Builder connectedComponentArns(Collection<String> connectedComponentArns) {
            this.connectedComponentArns = ComponentArnListCopier.copy(connectedComponentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectedComponentArns(String ... connectedComponentArns) {
            this.connectedComponentArns(Arrays.asList(connectedComponentArns));
            return this;
        }

        public Database build() {
            return new Database(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Database> {
        public Builder applicationId(String var1);

        public Builder componentId(String var1);

        public Builder credentials(Collection<ApplicationCredential> var1);

        public Builder credentials(ApplicationCredential ... var1);

        public Builder credentials(Consumer<ApplicationCredential.Builder> ... var1);

        public Builder databaseId(String var1);

        public Builder databaseName(String var1);

        public Builder databaseType(String var1);

        public Builder databaseType(DatabaseType var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(DatabaseStatus var1);

        public Builder primaryHost(String var1);

        public Builder sqlPort(Integer var1);

        public Builder lastUpdated(Instant var1);

        public Builder connectedComponentArns(Collection<String> var1);

        public Builder connectedComponentArns(String ... var1);
    }
}

