/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.Engagement;
import software.amazon.awssdk.services.ssmcontacts.model.EngagementsListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementsResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, ListEngagementsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementsResponse.getter(ListEngagementsResponse::nextToken)).setter(ListEngagementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Engagement>> ENGAGEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Engagements").getter(ListEngagementsResponse.getter(ListEngagementsResponse::engagements)).setter(ListEngagementsResponse.setter(Builder::engagements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engagements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Engagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ENGAGEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Engagements", ENGAGEMENTS_FIELD);
        }
    });
    private final String nextToken;
    private final List<Engagement> engagements;

    private ListEngagementsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.engagements = builder.engagements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEngagements() {
        return this.engagements != null && !(this.engagements instanceof SdkAutoConstructList);
    }

    public final List<Engagement> engagements() {
        return this.engagements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagements() ? this.engagements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsResponse)) {
            return false;
        }
        ListEngagementsResponse other = (ListEngagementsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEngagements() == other.hasEngagements() && Objects.equals(this.engagements(), other.engagements());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementsResponse").add("NextToken", (Object)this.nextToken()).add("Engagements", this.hasEngagements() ? this.engagements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Engagements": {
                return Optional.ofNullable(clazz.cast(this.engagements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsResponse, T> g) {
        return obj -> g.apply((ListEngagementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Engagement> engagements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.engagements(model.engagements);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Engagement.Builder> getEngagements() {
            List<Engagement.Builder> result = EngagementsListCopier.copyToBuilder(this.engagements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngagements(Collection<Engagement.BuilderImpl> engagements) {
            this.engagements = EngagementsListCopier.copyFromBuilder(engagements);
        }

        @Override
        public final Builder engagements(Collection<Engagement> engagements) {
            this.engagements = EngagementsListCopier.copy(engagements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagements(Engagement ... engagements) {
            this.engagements(Arrays.asList(engagements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagements(Consumer<Engagement.Builder> ... engagements) {
            this.engagements(Stream.of(engagements).map(c -> (Engagement)((Engagement.Builder)Engagement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEngagementsResponse build() {
            return new ListEngagementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementsResponse> {
        public Builder nextToken(String var1);

        public Builder engagements(Collection<Engagement> var1);

        public Builder engagements(Engagement ... var1);

        public Builder engagements(Consumer<Engagement.Builder> ... var1);
    }
}

