/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRotationOverrideRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, DeleteRotationOverrideRequest> {
    private static final SdkField<String> ROTATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationId").getter(DeleteRotationOverrideRequest.getter(DeleteRotationOverrideRequest::rotationId)).setter(DeleteRotationOverrideRequest.setter(Builder::rotationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationId").build()}).build();
    private static final SdkField<String> ROTATION_OVERRIDE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationOverrideId").getter(DeleteRotationOverrideRequest.getter(DeleteRotationOverrideRequest::rotationOverrideId)).setter(DeleteRotationOverrideRequest.setter(Builder::rotationOverrideId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOverrideId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ID_FIELD, ROTATION_OVERRIDE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RotationId", ROTATION_ID_FIELD);
            this.put("RotationOverrideId", ROTATION_OVERRIDE_ID_FIELD);
        }
    });
    private final String rotationId;
    private final String rotationOverrideId;

    private DeleteRotationOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.rotationId = builder.rotationId;
        this.rotationOverrideId = builder.rotationOverrideId;
    }

    public final String rotationId() {
        return this.rotationId;
    }

    public final String rotationOverrideId() {
        return this.rotationOverrideId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationOverrideId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRotationOverrideRequest)) {
            return false;
        }
        DeleteRotationOverrideRequest other = (DeleteRotationOverrideRequest)((Object)obj);
        return Objects.equals(this.rotationId(), other.rotationId()) && Objects.equals(this.rotationOverrideId(), other.rotationOverrideId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRotationOverrideRequest").add("RotationId", (Object)this.rotationId()).add("RotationOverrideId", (Object)this.rotationOverrideId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationId": {
                return Optional.ofNullable(clazz.cast(this.rotationId()));
            }
            case "RotationOverrideId": {
                return Optional.ofNullable(clazz.cast(this.rotationOverrideId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRotationOverrideRequest, T> g) {
        return obj -> g.apply((DeleteRotationOverrideRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String rotationId;
        private String rotationOverrideId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRotationOverrideRequest model) {
            super(model);
            this.rotationId(model.rotationId);
            this.rotationOverrideId(model.rotationOverrideId);
        }

        public final String getRotationId() {
            return this.rotationId;
        }

        public final void setRotationId(String rotationId) {
            this.rotationId = rotationId;
        }

        @Override
        public final Builder rotationId(String rotationId) {
            this.rotationId = rotationId;
            return this;
        }

        public final String getRotationOverrideId() {
            return this.rotationOverrideId;
        }

        public final void setRotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
        }

        @Override
        public final Builder rotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRotationOverrideRequest build() {
            return new DeleteRotationOverrideRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRotationOverrideRequest> {
        public Builder rotationId(String var1);

        public Builder rotationOverrideId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

