/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.EncryptionConfiguration;
import software.amazon.awssdk.services.sfn.model.LoggingConfiguration;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.services.sfn.model.TracingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStateMachineRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, UpdateStateMachineRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::stateMachineArn)).setter(UpdateStateMachineRequest.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::definition)).setter(UpdateStateMachineRequest.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::roleArn)).setter(UpdateStateMachineRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfiguration").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::loggingConfiguration)).setter(UpdateStateMachineRequest.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build()}).build();
    private static final SdkField<TracingConfiguration> TRACING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tracingConfiguration").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::tracingConfiguration)).setter(UpdateStateMachineRequest.setter(Builder::tracingConfiguration)).constructor(TracingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingConfiguration").build()}).build();
    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publish").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::publish)).setter(UpdateStateMachineRequest.setter(Builder::publish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publish").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionDescription").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::versionDescription)).setter(UpdateStateMachineRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionDescription").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(UpdateStateMachineRequest.getter(UpdateStateMachineRequest::encryptionConfiguration)).setter(UpdateStateMachineRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, LOGGING_CONFIGURATION_FIELD, TRACING_CONFIGURATION_FIELD, PUBLISH_FIELD, VERSION_DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
            this.put("definition", DEFINITION_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("loggingConfiguration", LOGGING_CONFIGURATION_FIELD);
            this.put("tracingConfiguration", TRACING_CONFIGURATION_FIELD);
            this.put("publish", PUBLISH_FIELD);
            this.put("versionDescription", VERSION_DESCRIPTION_FIELD);
            this.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        }
    });
    private final String stateMachineArn;
    private final String definition;
    private final String roleArn;
    private final LoggingConfiguration loggingConfiguration;
    private final TracingConfiguration tracingConfiguration;
    private final Boolean publish;
    private final String versionDescription;
    private final EncryptionConfiguration encryptionConfiguration;

    private UpdateStateMachineRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.tracingConfiguration = builder.tracingConfiguration;
        this.publish = builder.publish;
        this.versionDescription = builder.versionDescription;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final String definition() {
        return this.definition;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final TracingConfiguration tracingConfiguration() {
        return this.tracingConfiguration;
    }

    public final Boolean publish() {
        return this.publish;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.publish());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateMachineRequest)) {
            return false;
        }
        UpdateStateMachineRequest other = (UpdateStateMachineRequest)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.tracingConfiguration(), other.tracingConfiguration()) && Objects.equals(this.publish(), other.publish()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStateMachineRequest").add("StateMachineArn", (Object)this.stateMachineArn()).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("TracingConfiguration", (Object)this.tracingConfiguration()).add("Publish", (Object)this.publish()).add("VersionDescription", (Object)(this.versionDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "loggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "tracingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.tracingConfiguration()));
            }
            case "publish": {
                return Optional.ofNullable(clazz.cast(this.publish()));
            }
            case "versionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateMachineRequest, T> g) {
        return obj -> g.apply((UpdateStateMachineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String definition;
        private String roleArn;
        private LoggingConfiguration loggingConfiguration;
        private TracingConfiguration tracingConfiguration;
        private Boolean publish;
        private String versionDescription;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateMachineRequest model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.definition(model.definition);
            this.roleArn(model.roleArn);
            this.loggingConfiguration(model.loggingConfiguration);
            this.tracingConfiguration(model.tracingConfiguration);
            this.publish(model.publish);
            this.versionDescription(model.versionDescription);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final TracingConfiguration.Builder getTracingConfiguration() {
            return this.tracingConfiguration != null ? this.tracingConfiguration.toBuilder() : null;
        }

        public final void setTracingConfiguration(TracingConfiguration.BuilderImpl tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration != null ? tracingConfiguration.build() : null;
        }

        @Override
        public final Builder tracingConfiguration(TracingConfiguration tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        public final Boolean getPublish() {
            return this.publish;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStateMachineRequest build() {
            return new UpdateStateMachineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStateMachineRequest> {
        public Builder stateMachineArn(String var1);

        public Builder definition(String var1);

        public Builder roleArn(String var1);

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder tracingConfiguration(TracingConfiguration var1);

        default public Builder tracingConfiguration(Consumer<TracingConfiguration.Builder> tracingConfiguration) {
            return this.tracingConfiguration((TracingConfiguration)((TracingConfiguration.Builder)TracingConfiguration.builder().applyMutation(tracingConfiguration)).build());
        }

        public Builder publish(Boolean var1);

        public Builder versionDescription(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

