/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MapRunListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MapRunListItem> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(MapRunListItem.getter(MapRunListItem::executionArn)).setter(MapRunListItem.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapRunArn").getter(MapRunListItem.getter(MapRunListItem::mapRunArn)).setter(MapRunListItem.setter(Builder::mapRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()}).build();
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(MapRunListItem.getter(MapRunListItem::stateMachineArn)).setter(MapRunListItem.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(MapRunListItem.getter(MapRunListItem::startDate)).setter(MapRunListItem.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopDate").getter(MapRunListItem.getter(MapRunListItem::stopDate)).setter(MapRunListItem.setter(Builder::stopDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, MAP_RUN_ARN_FIELD, STATE_MACHINE_ARN_FIELD, START_DATE_FIELD, STOP_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("executionArn", EXECUTION_ARN_FIELD);
            this.put("mapRunArn", MAP_RUN_ARN_FIELD);
            this.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
            this.put("startDate", START_DATE_FIELD);
            this.put("stopDate", STOP_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String executionArn;
    private final String mapRunArn;
    private final String stateMachineArn;
    private final Instant startDate;
    private final Instant stopDate;

    private MapRunListItem(BuilderImpl builder) {
        this.executionArn = builder.executionArn;
        this.mapRunArn = builder.mapRunArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final String mapRunArn() {
        return this.mapRunArn;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant stopDate() {
        return this.stopDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapRunListItem)) {
            return false;
        }
        MapRunListItem other = (MapRunListItem)obj;
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.mapRunArn(), other.mapRunArn()) && Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.stopDate(), other.stopDate());
    }

    public final String toString() {
        return ToString.builder((String)"MapRunListItem").add("ExecutionArn", (Object)this.executionArn()).add("MapRunArn", (Object)this.mapRunArn()).add("StateMachineArn", (Object)this.stateMachineArn()).add("StartDate", (Object)this.startDate()).add("StopDate", (Object)this.stopDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "mapRunArn": {
                return Optional.ofNullable(clazz.cast(this.mapRunArn()));
            }
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "stopDate": {
                return Optional.ofNullable(clazz.cast(this.stopDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MapRunListItem, T> g) {
        return obj -> g.apply((MapRunListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionArn;
        private String mapRunArn;
        private String stateMachineArn;
        private Instant startDate;
        private Instant stopDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MapRunListItem model) {
            this.executionArn(model.executionArn);
            this.mapRunArn(model.mapRunArn);
            this.stateMachineArn(model.stateMachineArn);
            this.startDate(model.startDate);
            this.stopDate(model.stopDate);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getMapRunArn() {
            return this.mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return this.stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public MapRunListItem build() {
            return new MapRunListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MapRunListItem> {
        public Builder executionArn(String var1);

        public Builder mapRunArn(String var1);

        public Builder stateMachineArn(String var1);

        public Builder startDate(Instant var1);

        public Builder stopDate(Instant var1);
    }
}

