/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ReviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewDetails> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReviewDetails.getter(ReviewDetails::statusAsString)).setter(ReviewDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaseId").getter(ReviewDetails.getter(ReviewDetails::caseId)).setter(ReviewDetails.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CASE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("CaseId", CASE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String caseId;

    private ReviewDetails(BuilderImpl builder) {
        this.status = builder.status;
        this.caseId = builder.caseId;
    }

    public final ReviewStatus status() {
        return ReviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String caseId() {
        return this.caseId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewDetails)) {
            return false;
        }
        ReviewDetails other = (ReviewDetails)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.caseId(), other.caseId());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewDetails").add("Status", (Object)this.statusAsString()).add("CaseId", (Object)this.caseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CaseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReviewDetails, T> g) {
        return obj -> g.apply((ReviewDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String caseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewDetails model) {
            this.status(model.status);
            this.caseId(model.caseId);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public ReviewDetails build() {
            return new ReviewDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewDetails> {
        public Builder status(String var1);

        public Builder status(ReviewStatus var1);

        public Builder caseId(String var1);
    }
}

