/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.SNSActionEncoding;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SNSAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SNSAction> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(SNSAction.getter(SNSAction::topicArn)).setter(SNSAction.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Encoding").getter(SNSAction.getter(SNSAction::encodingAsString)).setter(SNSAction.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encoding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, ENCODING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TopicArn", TOPIC_ARN_FIELD);
            this.put("Encoding", ENCODING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String topicArn;
    private final String encoding;

    private SNSAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.encoding = builder.encoding;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final SNSActionEncoding encoding() {
        return SNSActionEncoding.fromValue(this.encoding);
    }

    public final String encodingAsString() {
        return this.encoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNSAction)) {
            return false;
        }
        SNSAction other = (SNSAction)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.encodingAsString(), other.encodingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SNSAction").add("TopicArn", (Object)this.topicArn()).add("Encoding", (Object)this.encodingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "Encoding": {
                return Optional.ofNullable(clazz.cast(this.encodingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SNSAction, T> g) {
        return obj -> g.apply((SNSAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(SNSAction model) {
            this.topicArn(model.topicArn);
            this.encoding(model.encoding);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(SNSActionEncoding encoding) {
            this.encoding(encoding == null ? null : encoding.toString());
            return this;
        }

        public SNSAction build() {
            return new SNSAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SNSAction> {
        public Builder topicArn(String var1);

        public Builder encoding(String var1);

        public Builder encoding(SNSActionEncoding var1);
    }
}

