/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<List<String>> TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ToAddresses").getter(Destination.getter(Destination::toAddresses)).setter(Destination.setter(Builder::toAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CC_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CcAddresses").getter(Destination.getter(Destination::ccAddresses)).setter(Destination.setter(Builder::ccAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CcAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BCC_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BccAddresses").getter(Destination.getter(Destination::bccAddresses)).setter(Destination.setter(Builder::bccAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BccAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_ADDRESSES_FIELD, CC_ADDRESSES_FIELD, BCC_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ToAddresses", TO_ADDRESSES_FIELD);
            this.put("CcAddresses", CC_ADDRESSES_FIELD);
            this.put("BccAddresses", BCC_ADDRESSES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> toAddresses;
    private final List<String> ccAddresses;
    private final List<String> bccAddresses;

    private Destination(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
        this.bccAddresses = builder.bccAddresses;
    }

    public final boolean hasToAddresses() {
        return this.toAddresses != null && !(this.toAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> toAddresses() {
        return this.toAddresses;
    }

    public final boolean hasCcAddresses() {
        return this.ccAddresses != null && !(this.ccAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> ccAddresses() {
        return this.ccAddresses;
    }

    public final boolean hasBccAddresses() {
        return this.bccAddresses != null && !(this.bccAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> bccAddresses() {
        return this.bccAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToAddresses() ? this.toAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCcAddresses() ? this.ccAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBccAddresses() ? this.bccAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return this.hasToAddresses() == other.hasToAddresses() && Objects.equals(this.toAddresses(), other.toAddresses()) && this.hasCcAddresses() == other.hasCcAddresses() && Objects.equals(this.ccAddresses(), other.ccAddresses()) && this.hasBccAddresses() == other.hasBccAddresses() && Objects.equals(this.bccAddresses(), other.bccAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("ToAddresses", this.hasToAddresses() ? this.toAddresses() : null).add("CcAddresses", this.hasCcAddresses() ? this.ccAddresses() : null).add("BccAddresses", this.hasBccAddresses() ? this.bccAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ToAddresses": {
                return Optional.ofNullable(clazz.cast(this.toAddresses()));
            }
            case "CcAddresses": {
                return Optional.ofNullable(clazz.cast(this.ccAddresses()));
            }
            case "BccAddresses": {
                return Optional.ofNullable(clazz.cast(this.bccAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> toAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> ccAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> bccAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.toAddresses(model.toAddresses);
            this.ccAddresses(model.ccAddresses);
            this.bccAddresses(model.bccAddresses);
        }

        public final Collection<String> getToAddresses() {
            if (this.toAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.toAddresses;
        }

        public final void setToAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
        }

        @Override
        public final Builder toAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(String ... toAddresses) {
            this.toAddresses(Arrays.asList(toAddresses));
            return this;
        }

        public final Collection<String> getCcAddresses() {
            if (this.ccAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ccAddresses;
        }

        public final void setCcAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
        }

        @Override
        public final Builder ccAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(String ... ccAddresses) {
            this.ccAddresses(Arrays.asList(ccAddresses));
            return this;
        }

        public final Collection<String> getBccAddresses() {
            if (this.bccAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bccAddresses;
        }

        public final void setBccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
        }

        @Override
        public final Builder bccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bccAddresses(String ... bccAddresses) {
            this.bccAddresses(Arrays.asList(bccAddresses));
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder toAddresses(Collection<String> var1);

        public Builder toAddresses(String ... var1);

        public Builder ccAddresses(Collection<String> var1);

        public Builder ccAddresses(String ... var1);

        public Builder bccAddresses(Collection<String> var1);

        public Builder bccAddresses(String ... var1);
    }
}

