/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate;

public class ListServiceQuotaIncreaseRequestsInTemplatePublisher
implements SdkPublisher<ListServiceQuotaIncreaseRequestsInTemplateResponse> {
    private final ServiceQuotasAsyncClient client;
    private final ListServiceQuotaIncreaseRequestsInTemplateRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceQuotaIncreaseRequestsInTemplatePublisher(ServiceQuotasAsyncClient client, ListServiceQuotaIncreaseRequestsInTemplateRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceQuotaIncreaseRequestsInTemplatePublisher(ServiceQuotasAsyncClient client, ListServiceQuotaIncreaseRequestsInTemplateRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceQuotaIncreaseRequestsInTemplateResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceQuotaIncreaseRequestsInTemplateResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList() {
        Function<ListServiceQuotaIncreaseRequestsInTemplateResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceQuotaIncreaseRequestInTemplateList() != null) {
                return response.serviceQuotaIncreaseRequestInTemplateList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceQuotaIncreaseRequestsInTemplateResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceQuotaIncreaseRequestsInTemplateResponseFetcher
    implements AsyncPageFetcher<ListServiceQuotaIncreaseRequestsInTemplateResponse> {
        private ListServiceQuotaIncreaseRequestsInTemplateResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceQuotaIncreaseRequestsInTemplateResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> nextPage(ListServiceQuotaIncreaseRequestsInTemplateResponse previousPage) {
            if (previousPage == null) {
                return ListServiceQuotaIncreaseRequestsInTemplatePublisher.this.client.listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplatePublisher.this.firstRequest);
            }
            return ListServiceQuotaIncreaseRequestsInTemplatePublisher.this.client.listServiceQuotaIncreaseRequestsInTemplate((ListServiceQuotaIncreaseRequestsInTemplateRequest)((Object)ListServiceQuotaIncreaseRequestsInTemplatePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

