/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.HttpNamespaceChange;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHttpNamespaceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, UpdateHttpNamespaceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateHttpNamespaceRequest.getter(UpdateHttpNamespaceRequest::id)).setter(UpdateHttpNamespaceRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> UPDATER_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdaterRequestId").getter(UpdateHttpNamespaceRequest.getter(UpdateHttpNamespaceRequest::updaterRequestId)).setter(UpdateHttpNamespaceRequest.setter(Builder::updaterRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdaterRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<HttpNamespaceChange> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Namespace").getter(UpdateHttpNamespaceRequest.getter(UpdateHttpNamespaceRequest::namespace)).setter(UpdateHttpNamespaceRequest.setter(Builder::namespace)).constructor(HttpNamespaceChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, UPDATER_REQUEST_ID_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("UpdaterRequestId", UPDATER_REQUEST_ID_FIELD);
            this.put("Namespace", NAMESPACE_FIELD);
        }
    });
    private final String id;
    private final String updaterRequestId;
    private final HttpNamespaceChange namespace;

    private UpdateHttpNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.updaterRequestId = builder.updaterRequestId;
        this.namespace = builder.namespace;
    }

    public final String id() {
        return this.id;
    }

    public final String updaterRequestId() {
        return this.updaterRequestId;
    }

    public final HttpNamespaceChange namespace() {
        return this.namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.updaterRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHttpNamespaceRequest)) {
            return false;
        }
        UpdateHttpNamespaceRequest other = (UpdateHttpNamespaceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.updaterRequestId(), other.updaterRequestId()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHttpNamespaceRequest").add("Id", (Object)this.id()).add("UpdaterRequestId", (Object)this.updaterRequestId()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "UpdaterRequestId": {
                return Optional.ofNullable(clazz.cast(this.updaterRequestId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHttpNamespaceRequest, T> g) {
        return obj -> g.apply((UpdateHttpNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String id;
        private String updaterRequestId;
        private HttpNamespaceChange namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHttpNamespaceRequest model) {
            super(model);
            this.id(model.id);
            this.updaterRequestId(model.updaterRequestId);
            this.namespace(model.namespace);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUpdaterRequestId() {
            return this.updaterRequestId;
        }

        public final void setUpdaterRequestId(String updaterRequestId) {
            this.updaterRequestId = updaterRequestId;
        }

        @Override
        public final Builder updaterRequestId(String updaterRequestId) {
            this.updaterRequestId = updaterRequestId;
            return this;
        }

        public final HttpNamespaceChange.Builder getNamespace() {
            return this.namespace != null ? this.namespace.toBuilder() : null;
        }

        public final void setNamespace(HttpNamespaceChange.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public final Builder namespace(HttpNamespaceChange namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHttpNamespaceRequest build() {
            return new UpdateHttpNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHttpNamespaceRequest> {
        public Builder id(String var1);

        public Builder updaterRequestId(String var1);

        public Builder namespace(HttpNamespaceChange var1);

        default public Builder namespace(Consumer<HttpNamespaceChange.Builder> namespace) {
            return this.namespace((HttpNamespaceChange)((HttpNamespaceChange.Builder)HttpNamespaceChange.builder().applyMutation(namespace)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

