/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcesListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcesListItem> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(ResourcesListItem.getter(ResourcesListItem::resourceArn)).setter(ResourcesListItem.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(ResourcesListItem.getter(ResourcesListItem::errorMessage)).setter(ResourcesListItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ResourcesListItem.getter(ResourcesListItem::status)).setter(ResourcesListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResourcesListItem.getter(ResourcesListItem::resourceType)).setter(ResourcesListItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ERROR_MESSAGE_FIELD, STATUS_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String errorMessage;
    private final String status;
    private final String resourceType;

    private ResourcesListItem(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
        this.resourceType = builder.resourceType;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String status() {
        return this.status;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesListItem)) {
            return false;
        }
        ResourcesListItem other = (ResourcesListItem)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcesListItem").add("ResourceArn", (Object)this.resourceArn()).add("ErrorMessage", (Object)this.errorMessage()).add("Status", (Object)this.status()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourcesListItem, T> g) {
        return obj -> g.apply((ResourcesListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String errorMessage;
        private String status;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesListItem model) {
            this.resourceArn(model.resourceArn);
            this.errorMessage(model.errorMessage);
            this.status(model.status);
            this.resourceType(model.resourceType);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourcesListItem build() {
            return new ResourcesListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcesListItem> {
        public Builder resourceArn(String var1);

        public Builder errorMessage(String var1);

        public Builder status(String var1);

        public Builder resourceType(String var1);
    }
}

