/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceItemStatus {
    SUCCESS("SUCCESS"),
    FAILED("FAILED"),
    IN_PROGRESS("IN_PROGRESS"),
    SKIPPED("SKIPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceItemStatus> VALUE_MAP;
    private final String value;

    private ResourceItemStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceItemStatus> knownValues() {
        EnumSet<ResourceItemStatus> knownValues = EnumSet.allOf(ResourceItemStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceItemStatus.class, ResourceItemStatus::toString);
    }
}

