/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummariesCopier;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAttributeGroupsResponse
extends ServiceCatalogAppRegistryResponse
implements ToCopyableBuilder<Builder, ListAttributeGroupsResponse> {
    private static final SdkField<List<AttributeGroupSummary>> ATTRIBUTE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeGroups").getter(ListAttributeGroupsResponse.getter(ListAttributeGroupsResponse::attributeGroups)).setter(ListAttributeGroupsResponse.setter(Builder::attributeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAttributeGroupsResponse.getter(ListAttributeGroupsResponse::nextToken)).setter(ListAttributeGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("attributeGroups", ATTRIBUTE_GROUPS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AttributeGroupSummary> attributeGroups;
    private final String nextToken;

    private ListAttributeGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.attributeGroups = builder.attributeGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAttributeGroups() {
        return this.attributeGroups != null && !(this.attributeGroups instanceof SdkAutoConstructList);
    }

    public final List<AttributeGroupSummary> attributeGroups() {
        return this.attributeGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeGroups() ? this.attributeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttributeGroupsResponse)) {
            return false;
        }
        ListAttributeGroupsResponse other = (ListAttributeGroupsResponse)((Object)obj);
        return this.hasAttributeGroups() == other.hasAttributeGroups() && Objects.equals(this.attributeGroups(), other.attributeGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAttributeGroupsResponse").add("AttributeGroups", this.hasAttributeGroups() ? this.attributeGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributeGroups": {
                return Optional.ofNullable(clazz.cast(this.attributeGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAttributeGroupsResponse, T> g) {
        return obj -> g.apply((ListAttributeGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryResponse.BuilderImpl
    implements Builder {
        private List<AttributeGroupSummary> attributeGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttributeGroupsResponse model) {
            super(model);
            this.attributeGroups(model.attributeGroups);
            this.nextToken(model.nextToken);
        }

        public final List<AttributeGroupSummary.Builder> getAttributeGroups() {
            List<AttributeGroupSummary.Builder> result = AttributeGroupSummariesCopier.copyToBuilder(this.attributeGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeGroups(Collection<AttributeGroupSummary.BuilderImpl> attributeGroups) {
            this.attributeGroups = AttributeGroupSummariesCopier.copyFromBuilder(attributeGroups);
        }

        @Override
        public final Builder attributeGroups(Collection<AttributeGroupSummary> attributeGroups) {
            this.attributeGroups = AttributeGroupSummariesCopier.copy(attributeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeGroups(AttributeGroupSummary ... attributeGroups) {
            this.attributeGroups(Arrays.asList(attributeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeGroups(Consumer<AttributeGroupSummary.Builder> ... attributeGroups) {
            this.attributeGroups(Stream.of(attributeGroups).map(c -> (AttributeGroupSummary)((AttributeGroupSummary.Builder)AttributeGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttributeGroupsResponse build() {
            return new ListAttributeGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogAppRegistryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAttributeGroupsResponse> {
        public Builder attributeGroups(Collection<AttributeGroupSummary> var1);

        public Builder attributeGroups(AttributeGroupSummary ... var1);

        public Builder attributeGroups(Consumer<AttributeGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

