/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ChangeAction;
import software.amazon.awssdk.services.servicecatalog.model.Replacement;
import software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ScopeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceChange> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ResourceChange.getter(ResourceChange::actionAsString)).setter(ResourceChange.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(ResourceChange.getter(ResourceChange::logicalResourceId)).setter(ResourceChange.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalResourceId").getter(ResourceChange.getter(ResourceChange::physicalResourceId)).setter(ResourceChange.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceChange.getter(ResourceChange::resourceType)).setter(ResourceChange.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> REPLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Replacement").getter(ResourceChange.getter(ResourceChange::replacementAsString)).setter(ResourceChange.setter(Builder::replacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replacement").build()}).build();
    private static final SdkField<List<String>> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scope").getter(ResourceChange.getter(ResourceChange::scopeAsStrings)).setter(ResourceChange.setter(Builder::scopeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceChangeDetail>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Details").getter(ResourceChange.getter(ResourceChange::details)).setter(ResourceChange.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceChangeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, REPLACEMENT_FIELD, SCOPE_FIELD, DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Action", ACTION_FIELD);
            this.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
            this.put("PhysicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("Replacement", REPLACEMENT_FIELD);
            this.put("Scope", SCOPE_FIELD);
            this.put("Details", DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final String replacement;
    private final List<String> scope;
    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Replacement replacement() {
        return Replacement.fromValue(this.replacement);
    }

    public final String replacementAsString() {
        return this.replacement;
    }

    public final List<ResourceAttribute> scope() {
        return ScopeCopier.copyStringToEnum(this.scope);
    }

    public final boolean hasScope() {
        return this.scope != null && !(this.scope instanceof SdkAutoConstructList);
    }

    public final List<String> scopeAsStrings() {
        return this.scope;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<ResourceChangeDetail> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScope() ? this.scopeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.replacementAsString(), other.replacementAsString()) && this.hasScope() == other.hasScope() && Objects.equals(this.scopeAsStrings(), other.scopeAsStrings()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceChange").add("Action", (Object)this.actionAsString()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Replacement", (Object)this.replacementAsString()).add("Scope", this.hasScope() ? this.scopeAsStrings() : null).add("Details", this.hasDetails() ? this.details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Replacement": {
                return Optional.ofNullable(clazz.cast(this.replacementAsString()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsStrings()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceChange, T> g) {
        return obj -> g.apply((ResourceChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private String replacement;
        private List<String> scope = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceChangeDetail> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            this.action(model.action);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.replacement(model.replacement);
            this.scopeWithStrings(model.scope);
            this.details(model.details);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getReplacement() {
            return this.replacement;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement == null ? null : replacement.toString());
            return this;
        }

        public final Collection<String> getScope() {
            if (this.scope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        @Override
        public final Builder scopeWithStrings(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopeWithStrings(String ... scope) {
            this.scopeWithStrings(Arrays.asList(scope));
            return this;
        }

        @Override
        public final Builder scope(Collection<ResourceAttribute> scope) {
            this.scope = ScopeCopier.copyEnumToString(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(ResourceAttribute ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final List<ResourceChangeDetail.Builder> getDetails() {
            List<ResourceChangeDetail.Builder> result = ResourceChangeDetailsCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<ResourceChangeDetail.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (ResourceChangeDetail)((ResourceChangeDetail.Builder)ResourceChangeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceChange build() {
            return new ResourceChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceChange> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder replacement(String var1);

        public Builder replacement(Replacement var1);

        public Builder scopeWithStrings(Collection<String> var1);

        public Builder scopeWithStrings(String ... var1);

        public Builder scope(Collection<ResourceAttribute> var1);

        public Builder scope(ResourceAttribute ... var1);

        public Builder details(Collection<ResourceChangeDetail> var1);

        public Builder details(ResourceChangeDetail ... var1);

        public Builder details(Consumer<ResourceChangeDetail.Builder> ... var1);
    }
}

