/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.AwsIdentity;
import software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLogSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLogSourceConfiguration> {
    private static final SdkField<CustomLogSourceCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerConfiguration").getter(CustomLogSourceConfiguration.getter(CustomLogSourceConfiguration::crawlerConfiguration)).setter(CustomLogSourceConfiguration.setter(Builder::crawlerConfiguration)).constructor(CustomLogSourceCrawlerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build()}).build();
    private static final SdkField<AwsIdentity> PROVIDER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerIdentity").getter(CustomLogSourceConfiguration.getter(CustomLogSourceConfiguration::providerIdentity)).setter(CustomLogSourceConfiguration.setter(Builder::providerIdentity)).constructor(AwsIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_CONFIGURATION_FIELD, PROVIDER_IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("crawlerConfiguration", CRAWLER_CONFIGURATION_FIELD);
            this.put("providerIdentity", PROVIDER_IDENTITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CustomLogSourceCrawlerConfiguration crawlerConfiguration;
    private final AwsIdentity providerIdentity;

    private CustomLogSourceConfiguration(BuilderImpl builder) {
        this.crawlerConfiguration = builder.crawlerConfiguration;
        this.providerIdentity = builder.providerIdentity;
    }

    public final CustomLogSourceCrawlerConfiguration crawlerConfiguration() {
        return this.crawlerConfiguration;
    }

    public final AwsIdentity providerIdentity() {
        return this.providerIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLogSourceConfiguration)) {
            return false;
        }
        CustomLogSourceConfiguration other = (CustomLogSourceConfiguration)obj;
        return Objects.equals(this.crawlerConfiguration(), other.crawlerConfiguration()) && Objects.equals(this.providerIdentity(), other.providerIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"CustomLogSourceConfiguration").add("CrawlerConfiguration", (Object)this.crawlerConfiguration()).add("ProviderIdentity", (Object)this.providerIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crawlerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerConfiguration()));
            }
            case "providerIdentity": {
                return Optional.ofNullable(clazz.cast(this.providerIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomLogSourceConfiguration, T> g) {
        return obj -> g.apply((CustomLogSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CustomLogSourceCrawlerConfiguration crawlerConfiguration;
        private AwsIdentity providerIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLogSourceConfiguration model) {
            this.crawlerConfiguration(model.crawlerConfiguration);
            this.providerIdentity(model.providerIdentity);
        }

        public final CustomLogSourceCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return this.crawlerConfiguration != null ? this.crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(CustomLogSourceCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(CustomLogSourceCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public final AwsIdentity.Builder getProviderIdentity() {
            return this.providerIdentity != null ? this.providerIdentity.toBuilder() : null;
        }

        public final void setProviderIdentity(AwsIdentity.BuilderImpl providerIdentity) {
            this.providerIdentity = providerIdentity != null ? providerIdentity.build() : null;
        }

        @Override
        public final Builder providerIdentity(AwsIdentity providerIdentity) {
            this.providerIdentity = providerIdentity;
            return this;
        }

        public CustomLogSourceConfiguration build() {
            return new CustomLogSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLogSourceConfiguration> {
        public Builder crawlerConfiguration(CustomLogSourceCrawlerConfiguration var1);

        default public Builder crawlerConfiguration(Consumer<CustomLogSourceCrawlerConfiguration.Builder> crawlerConfiguration) {
            return this.crawlerConfiguration((CustomLogSourceCrawlerConfiguration)((CustomLogSourceCrawlerConfiguration.Builder)CustomLogSourceCrawlerConfiguration.builder().applyMutation(crawlerConfiguration)).build());
        }

        public Builder providerIdentity(AwsIdentity var1);

        default public Builder providerIdentity(Consumer<AwsIdentity.Builder> providerIdentity) {
            return this.providerIdentity((AwsIdentity)((AwsIdentity.Builder)AwsIdentity.builder().applyMutation(providerIdentity)).build());
        }
    }
}

