/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails;
import software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails;
import software.amazon.awssdk.services.securityhub.model.ActionRemotePortDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkConnectionAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkConnectionAction> {
    private static final SdkField<String> CONNECTION_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionDirection").getter(NetworkConnectionAction.getter(NetworkConnectionAction::connectionDirection)).setter(NetworkConnectionAction.setter(Builder::connectionDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDirection").build()}).build();
    private static final SdkField<ActionRemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::remoteIpDetails)).setter(NetworkConnectionAction.setter(Builder::remoteIpDetails)).constructor(ActionRemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpDetails").build()}).build();
    private static final SdkField<ActionRemotePortDetails> REMOTE_PORT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemotePortDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::remotePortDetails)).setter(NetworkConnectionAction.setter(Builder::remotePortDetails)).constructor(ActionRemotePortDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemotePortDetails").build()}).build();
    private static final SdkField<ActionLocalPortDetails> LOCAL_PORT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalPortDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::localPortDetails)).setter(NetworkConnectionAction.setter(Builder::localPortDetails)).constructor(ActionLocalPortDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPortDetails").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(NetworkConnectionAction.getter(NetworkConnectionAction::protocol)).setter(NetworkConnectionAction.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Blocked").getter(NetworkConnectionAction.getter(NetworkConnectionAction::blocked)).setter(NetworkConnectionAction.setter(Builder::blocked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocked").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_DIRECTION_FIELD, REMOTE_IP_DETAILS_FIELD, REMOTE_PORT_DETAILS_FIELD, LOCAL_PORT_DETAILS_FIELD, PROTOCOL_FIELD, BLOCKED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionDirection", CONNECTION_DIRECTION_FIELD);
            this.put("RemoteIpDetails", REMOTE_IP_DETAILS_FIELD);
            this.put("RemotePortDetails", REMOTE_PORT_DETAILS_FIELD);
            this.put("LocalPortDetails", LOCAL_PORT_DETAILS_FIELD);
            this.put("Protocol", PROTOCOL_FIELD);
            this.put("Blocked", BLOCKED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String connectionDirection;
    private final ActionRemoteIpDetails remoteIpDetails;
    private final ActionRemotePortDetails remotePortDetails;
    private final ActionLocalPortDetails localPortDetails;
    private final String protocol;
    private final Boolean blocked;

    private NetworkConnectionAction(BuilderImpl builder) {
        this.connectionDirection = builder.connectionDirection;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.remotePortDetails = builder.remotePortDetails;
        this.localPortDetails = builder.localPortDetails;
        this.protocol = builder.protocol;
        this.blocked = builder.blocked;
    }

    public final String connectionDirection() {
        return this.connectionDirection;
    }

    public final ActionRemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public final ActionRemotePortDetails remotePortDetails() {
        return this.remotePortDetails;
    }

    public final ActionLocalPortDetails localPortDetails() {
        return this.localPortDetails;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final Boolean blocked() {
        return this.blocked;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDirection());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remotePortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.blocked());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConnectionAction)) {
            return false;
        }
        NetworkConnectionAction other = (NetworkConnectionAction)obj;
        return Objects.equals(this.connectionDirection(), other.connectionDirection()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.remotePortDetails(), other.remotePortDetails()) && Objects.equals(this.localPortDetails(), other.localPortDetails()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.blocked(), other.blocked());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkConnectionAction").add("ConnectionDirection", (Object)this.connectionDirection()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("RemotePortDetails", (Object)this.remotePortDetails()).add("LocalPortDetails", (Object)this.localPortDetails()).add("Protocol", (Object)this.protocol()).add("Blocked", (Object)this.blocked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionDirection": {
                return Optional.ofNullable(clazz.cast(this.connectionDirection()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "RemotePortDetails": {
                return Optional.ofNullable(clazz.cast(this.remotePortDetails()));
            }
            case "LocalPortDetails": {
                return Optional.ofNullable(clazz.cast(this.localPortDetails()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Blocked": {
                return Optional.ofNullable(clazz.cast(this.blocked()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConnectionAction, T> g) {
        return obj -> g.apply((NetworkConnectionAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionDirection;
        private ActionRemoteIpDetails remoteIpDetails;
        private ActionRemotePortDetails remotePortDetails;
        private ActionLocalPortDetails localPortDetails;
        private String protocol;
        private Boolean blocked;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConnectionAction model) {
            this.connectionDirection(model.connectionDirection);
            this.remoteIpDetails(model.remoteIpDetails);
            this.remotePortDetails(model.remotePortDetails);
            this.localPortDetails(model.localPortDetails);
            this.protocol(model.protocol);
            this.blocked(model.blocked);
        }

        public final String getConnectionDirection() {
            return this.connectionDirection;
        }

        public final void setConnectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
        }

        @Override
        public final Builder connectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
            return this;
        }

        public final ActionRemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(ActionRemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final ActionRemotePortDetails.Builder getRemotePortDetails() {
            return this.remotePortDetails != null ? this.remotePortDetails.toBuilder() : null;
        }

        public final void setRemotePortDetails(ActionRemotePortDetails.BuilderImpl remotePortDetails) {
            this.remotePortDetails = remotePortDetails != null ? remotePortDetails.build() : null;
        }

        @Override
        public final Builder remotePortDetails(ActionRemotePortDetails remotePortDetails) {
            this.remotePortDetails = remotePortDetails;
            return this;
        }

        public final ActionLocalPortDetails.Builder getLocalPortDetails() {
            return this.localPortDetails != null ? this.localPortDetails.toBuilder() : null;
        }

        public final void setLocalPortDetails(ActionLocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        @Override
        public final Builder localPortDetails(ActionLocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Boolean getBlocked() {
            return this.blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public NetworkConnectionAction build() {
            return new NetworkConnectionAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkConnectionAction> {
        public Builder connectionDirection(String var1);

        public Builder remoteIpDetails(ActionRemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<ActionRemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((ActionRemoteIpDetails)((ActionRemoteIpDetails.Builder)ActionRemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder remotePortDetails(ActionRemotePortDetails var1);

        default public Builder remotePortDetails(Consumer<ActionRemotePortDetails.Builder> remotePortDetails) {
            return this.remotePortDetails((ActionRemotePortDetails)((ActionRemotePortDetails.Builder)ActionRemotePortDetails.builder().applyMutation(remotePortDetails)).build());
        }

        public Builder localPortDetails(ActionLocalPortDetails var1);

        default public Builder localPortDetails(Consumer<ActionLocalPortDetails.Builder> localPortDetails) {
            return this.localPortDetails((ActionLocalPortDetails)((ActionLocalPortDetails.Builder)ActionLocalPortDetails.builder().applyMutation(localPortDetails)).build());
        }

        public Builder protocol(String var1);

        public Builder blocked(Boolean var1);
    }
}

