/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafv2RuleGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafv2RuleGroupDetails> {
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Capacity").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::capacity)).setter(AwsWafv2RuleGroupDetails.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::description)).setter(AwsWafv2RuleGroupDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::id)).setter(AwsWafv2RuleGroupDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::name)).setter(AwsWafv2RuleGroupDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::arn)).setter(AwsWafv2RuleGroupDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<AwsWafv2RulesDetails>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::rules)).setter(AwsWafv2RuleGroupDetails.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafv2RulesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::scope)).setter(AwsWafv2RuleGroupDetails.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<AwsWafv2VisibilityConfigDetails> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(AwsWafv2RuleGroupDetails.getter(AwsWafv2RuleGroupDetails::visibilityConfig)).setter(AwsWafv2RuleGroupDetails.setter(Builder::visibilityConfig)).constructor(AwsWafv2VisibilityConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, ARN_FIELD, RULES_FIELD, SCOPE_FIELD, VISIBILITY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Capacity", CAPACITY_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Rules", RULES_FIELD);
            this.put("Scope", SCOPE_FIELD);
            this.put("VisibilityConfig", VISIBILITY_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long capacity;
    private final String description;
    private final String id;
    private final String name;
    private final String arn;
    private final List<AwsWafv2RulesDetails> rules;
    private final String scope;
    private final AwsWafv2VisibilityConfigDetails visibilityConfig;

    private AwsWafv2RuleGroupDetails(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.rules = builder.rules;
        this.scope = builder.scope;
        this.visibilityConfig = builder.visibilityConfig;
    }

    public final Long capacity() {
        return this.capacity;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AwsWafv2RulesDetails> rules() {
        return this.rules;
    }

    public final String scope() {
        return this.scope;
    }

    public final AwsWafv2VisibilityConfigDetails visibilityConfig() {
        return this.visibilityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2RuleGroupDetails)) {
            return false;
        }
        AwsWafv2RuleGroupDetails other = (AwsWafv2RuleGroupDetails)obj;
        return Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafv2RuleGroupDetails").add("Capacity", (Object)this.capacity()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Rules", this.hasRules() ? this.rules() : null).add("Scope", (Object)this.scope()).add("VisibilityConfig", (Object)this.visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2RuleGroupDetails, T> g) {
        return obj -> g.apply((AwsWafv2RuleGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long capacity;
        private String description;
        private String id;
        private String name;
        private String arn;
        private List<AwsWafv2RulesDetails> rules = DefaultSdkAutoConstructList.getInstance();
        private String scope;
        private AwsWafv2VisibilityConfigDetails visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2RuleGroupDetails model) {
            this.capacity(model.capacity);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.rules(model.rules);
            this.scope(model.scope);
            this.visibilityConfig(model.visibilityConfig);
        }

        public final Long getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<AwsWafv2RulesDetails.Builder> getRules() {
            List<AwsWafv2RulesDetails.Builder> result = AwsWafv2RulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafv2RulesDetails.BuilderImpl> rules) {
            this.rules = AwsWafv2RulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AwsWafv2RulesDetails> rules) {
            this.rules = AwsWafv2RulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafv2RulesDetails ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafv2RulesDetails.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AwsWafv2RulesDetails)((AwsWafv2RulesDetails.Builder)AwsWafv2RulesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final AwsWafv2VisibilityConfigDetails.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(AwsWafv2VisibilityConfigDetails.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public AwsWafv2RuleGroupDetails build() {
            return new AwsWafv2RuleGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafv2RuleGroupDetails> {
        public Builder capacity(Long var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder rules(Collection<AwsWafv2RulesDetails> var1);

        public Builder rules(AwsWafv2RulesDetails ... var1);

        public Builder rules(Consumer<AwsWafv2RulesDetails.Builder> ... var1);

        public Builder scope(String var1);

        public Builder visibilityConfig(AwsWafv2VisibilityConfigDetails var1);

        default public Builder visibilityConfig(Consumer<AwsWafv2VisibilityConfigDetails.Builder> visibilityConfig) {
            return this.visibilityConfig((AwsWafv2VisibilityConfigDetails)((AwsWafv2VisibilityConfigDetails.Builder)AwsWafv2VisibilityConfigDetails.builder().applyMutation(visibilityConfig)).build());
        }
    }
}

