/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDocumentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorEnrichmentJobInputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorEnrichmentJobInputConfig> {
    private static final SdkField<VectorEnrichmentJobDataSourceConfigInput> DATA_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceConfig").getter(VectorEnrichmentJobInputConfig.getter(VectorEnrichmentJobInputConfig::dataSourceConfig)).setter(VectorEnrichmentJobInputConfig.setter(Builder::dataSourceConfig)).constructor(VectorEnrichmentJobDataSourceConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfig").build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentType").getter(VectorEnrichmentJobInputConfig.getter(VectorEnrichmentJobInputConfig::documentTypeAsString)).setter(VectorEnrichmentJobInputConfig.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_CONFIG_FIELD, DOCUMENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSourceConfig", DATA_SOURCE_CONFIG_FIELD);
            this.put("DocumentType", DOCUMENT_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VectorEnrichmentJobDataSourceConfigInput dataSourceConfig;
    private final String documentType;

    private VectorEnrichmentJobInputConfig(BuilderImpl builder) {
        this.dataSourceConfig = builder.dataSourceConfig;
        this.documentType = builder.documentType;
    }

    public final VectorEnrichmentJobDataSourceConfigInput dataSourceConfig() {
        return this.dataSourceConfig;
    }

    public final VectorEnrichmentJobDocumentType documentType() {
        return VectorEnrichmentJobDocumentType.fromValue(this.documentType);
    }

    public final String documentTypeAsString() {
        return this.documentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorEnrichmentJobInputConfig)) {
            return false;
        }
        VectorEnrichmentJobInputConfig other = (VectorEnrichmentJobInputConfig)obj;
        return Objects.equals(this.dataSourceConfig(), other.dataSourceConfig()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VectorEnrichmentJobInputConfig").add("DataSourceConfig", (Object)this.dataSourceConfig()).add("DocumentType", (Object)this.documentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfig()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VectorEnrichmentJobInputConfig, T> g) {
        return obj -> g.apply((VectorEnrichmentJobInputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VectorEnrichmentJobDataSourceConfigInput dataSourceConfig;
        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorEnrichmentJobInputConfig model) {
            this.dataSourceConfig(model.dataSourceConfig);
            this.documentType(model.documentType);
        }

        public final VectorEnrichmentJobDataSourceConfigInput.Builder getDataSourceConfig() {
            return this.dataSourceConfig != null ? this.dataSourceConfig.toBuilder() : null;
        }

        public final void setDataSourceConfig(VectorEnrichmentJobDataSourceConfigInput.BuilderImpl dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig != null ? dataSourceConfig.build() : null;
        }

        @Override
        public final Builder dataSourceConfig(VectorEnrichmentJobDataSourceConfigInput dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            return this;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(VectorEnrichmentJobDocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public VectorEnrichmentJobInputConfig build() {
            return new VectorEnrichmentJobInputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorEnrichmentJobInputConfig> {
        public Builder dataSourceConfig(VectorEnrichmentJobDataSourceConfigInput var1);

        default public Builder dataSourceConfig(Consumer<VectorEnrichmentJobDataSourceConfigInput.Builder> dataSourceConfig) {
            return this.dataSourceConfig((VectorEnrichmentJobDataSourceConfigInput)((VectorEnrichmentJobDataSourceConfigInput.Builder)VectorEnrichmentJobDataSourceConfigInput.builder().applyMutation(dataSourceConfig)).build());
        }

        public Builder documentType(String var1);

        public Builder documentType(VectorEnrichmentJobDocumentType var1);
    }
}

