/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;

public class ListHyperParameterTuningJobsPublisher
implements SdkPublisher<ListHyperParameterTuningJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListHyperParameterTuningJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHyperParameterTuningJobsPublisher(SageMakerAsyncClient client, ListHyperParameterTuningJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHyperParameterTuningJobsPublisher(SageMakerAsyncClient client, ListHyperParameterTuningJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHyperParameterTuningJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHyperParameterTuningJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HyperParameterTuningJobSummary> hyperParameterTuningJobSummaries() {
        Function<ListHyperParameterTuningJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hyperParameterTuningJobSummaries() != null) {
                return response.hyperParameterTuningJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHyperParameterTuningJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHyperParameterTuningJobsResponseFetcher
    implements AsyncPageFetcher<ListHyperParameterTuningJobsResponse> {
        private ListHyperParameterTuningJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListHyperParameterTuningJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHyperParameterTuningJobsResponse> nextPage(ListHyperParameterTuningJobsResponse previousPage) {
            if (previousPage == null) {
                return ListHyperParameterTuningJobsPublisher.this.client.listHyperParameterTuningJobs(ListHyperParameterTuningJobsPublisher.this.firstRequest);
            }
            return ListHyperParameterTuningJobsPublisher.this.client.listHyperParameterTuningJobs((ListHyperParameterTuningJobsRequest)((Object)ListHyperParameterTuningJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

