/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesForecastingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesForecastingSettings> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TimeSeriesForecastingSettings.getter(TimeSeriesForecastingSettings::statusAsString)).setter(TimeSeriesForecastingSettings.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AMAZON_FORECAST_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmazonForecastRoleArn").getter(TimeSeriesForecastingSettings.getter(TimeSeriesForecastingSettings::amazonForecastRoleArn)).setter(TimeSeriesForecastingSettings.setter(Builder::amazonForecastRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonForecastRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, AMAZON_FORECAST_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("AmazonForecastRoleArn", AMAZON_FORECAST_ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String amazonForecastRoleArn;

    private TimeSeriesForecastingSettings(BuilderImpl builder) {
        this.status = builder.status;
        this.amazonForecastRoleArn = builder.amazonForecastRoleArn;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String amazonForecastRoleArn() {
        return this.amazonForecastRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonForecastRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesForecastingSettings)) {
            return false;
        }
        TimeSeriesForecastingSettings other = (TimeSeriesForecastingSettings)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.amazonForecastRoleArn(), other.amazonForecastRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesForecastingSettings").add("Status", (Object)this.statusAsString()).add("AmazonForecastRoleArn", (Object)this.amazonForecastRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AmazonForecastRoleArn": {
                return Optional.ofNullable(clazz.cast(this.amazonForecastRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesForecastingSettings, T> g) {
        return obj -> g.apply((TimeSeriesForecastingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String amazonForecastRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesForecastingSettings model) {
            this.status(model.status);
            this.amazonForecastRoleArn(model.amazonForecastRoleArn);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAmazonForecastRoleArn() {
            return this.amazonForecastRoleArn;
        }

        public final void setAmazonForecastRoleArn(String amazonForecastRoleArn) {
            this.amazonForecastRoleArn = amazonForecastRoleArn;
        }

        @Override
        public final Builder amazonForecastRoleArn(String amazonForecastRoleArn) {
            this.amazonForecastRoleArn = amazonForecastRoleArn;
            return this;
        }

        public TimeSeriesForecastingSettings build() {
            return new TimeSeriesForecastingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesForecastingSettings> {
        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder amazonForecastRoleArn(String var1);
    }
}

