/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantAction;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantActionMapCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopInferenceExperimentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, StopInferenceExperimentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StopInferenceExperimentRequest.getter(StopInferenceExperimentRequest::name)).setter(StopInferenceExperimentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> MODEL_VARIANT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ModelVariantActions").getter(StopInferenceExperimentRequest.getter(StopInferenceExperimentRequest::modelVariantActionsAsStrings)).setter(StopInferenceExperimentRequest.setter(Builder::modelVariantActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariantActions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ModelVariantConfig>> DESIRED_MODEL_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DesiredModelVariants").getter(StopInferenceExperimentRequest.getter(StopInferenceExperimentRequest::desiredModelVariants)).setter(StopInferenceExperimentRequest.setter(Builder::desiredModelVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredModelVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVariantConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(StopInferenceExperimentRequest.getter(StopInferenceExperimentRequest::desiredStateAsString)).setter(StopInferenceExperimentRequest.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(StopInferenceExperimentRequest.getter(StopInferenceExperimentRequest::reason)).setter(StopInferenceExperimentRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MODEL_VARIANT_ACTIONS_FIELD, DESIRED_MODEL_VARIANTS_FIELD, DESIRED_STATE_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("ModelVariantActions", MODEL_VARIANT_ACTIONS_FIELD);
            this.put("DesiredModelVariants", DESIRED_MODEL_VARIANTS_FIELD);
            this.put("DesiredState", DESIRED_STATE_FIELD);
            this.put("Reason", REASON_FIELD);
        }
    });
    private final String name;
    private final Map<String, String> modelVariantActions;
    private final List<ModelVariantConfig> desiredModelVariants;
    private final String desiredState;
    private final String reason;

    private StopInferenceExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.modelVariantActions = builder.modelVariantActions;
        this.desiredModelVariants = builder.desiredModelVariants;
        this.desiredState = builder.desiredState;
        this.reason = builder.reason;
    }

    public final String name() {
        return this.name;
    }

    public final Map<String, ModelVariantAction> modelVariantActions() {
        return ModelVariantActionMapCopier.copyStringToEnum(this.modelVariantActions);
    }

    public final boolean hasModelVariantActions() {
        return this.modelVariantActions != null && !(this.modelVariantActions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> modelVariantActionsAsStrings() {
        return this.modelVariantActions;
    }

    public final boolean hasDesiredModelVariants() {
        return this.desiredModelVariants != null && !(this.desiredModelVariants instanceof SdkAutoConstructList);
    }

    public final List<ModelVariantConfig> desiredModelVariants() {
        return this.desiredModelVariants;
    }

    public final InferenceExperimentStopDesiredState desiredState() {
        return InferenceExperimentStopDesiredState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final String reason() {
        return this.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVariantActions() ? this.modelVariantActionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDesiredModelVariants() ? this.desiredModelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInferenceExperimentRequest)) {
            return false;
        }
        StopInferenceExperimentRequest other = (StopInferenceExperimentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasModelVariantActions() == other.hasModelVariantActions() && Objects.equals(this.modelVariantActionsAsStrings(), other.modelVariantActionsAsStrings()) && this.hasDesiredModelVariants() == other.hasDesiredModelVariants() && Objects.equals(this.desiredModelVariants(), other.desiredModelVariants()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.reason(), other.reason());
    }

    public final String toString() {
        return ToString.builder((String)"StopInferenceExperimentRequest").add("Name", (Object)this.name()).add("ModelVariantActions", this.hasModelVariantActions() ? this.modelVariantActionsAsStrings() : null).add("DesiredModelVariants", this.hasDesiredModelVariants() ? this.desiredModelVariants() : null).add("DesiredState", (Object)this.desiredStateAsString()).add("Reason", (Object)this.reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ModelVariantActions": {
                return Optional.ofNullable(clazz.cast(this.modelVariantActionsAsStrings()));
            }
            case "DesiredModelVariants": {
                return Optional.ofNullable(clazz.cast(this.desiredModelVariants()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StopInferenceExperimentRequest, T> g) {
        return obj -> g.apply((StopInferenceExperimentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private Map<String, String> modelVariantActions = DefaultSdkAutoConstructMap.getInstance();
        private List<ModelVariantConfig> desiredModelVariants = DefaultSdkAutoConstructList.getInstance();
        private String desiredState;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInferenceExperimentRequest model) {
            super(model);
            this.name(model.name);
            this.modelVariantActionsWithStrings(model.modelVariantActions);
            this.desiredModelVariants(model.desiredModelVariants);
            this.desiredState(model.desiredState);
            this.reason(model.reason);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getModelVariantActions() {
            if (this.modelVariantActions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.modelVariantActions;
        }

        public final void setModelVariantActions(Map<String, String> modelVariantActions) {
            this.modelVariantActions = ModelVariantActionMapCopier.copy(modelVariantActions);
        }

        @Override
        public final Builder modelVariantActionsWithStrings(Map<String, String> modelVariantActions) {
            this.modelVariantActions = ModelVariantActionMapCopier.copy(modelVariantActions);
            return this;
        }

        @Override
        public final Builder modelVariantActions(Map<String, ModelVariantAction> modelVariantActions) {
            this.modelVariantActions = ModelVariantActionMapCopier.copyEnumToString(modelVariantActions);
            return this;
        }

        public final List<ModelVariantConfig.Builder> getDesiredModelVariants() {
            List<ModelVariantConfig.Builder> result = ModelVariantConfigListCopier.copyToBuilder(this.desiredModelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDesiredModelVariants(Collection<ModelVariantConfig.BuilderImpl> desiredModelVariants) {
            this.desiredModelVariants = ModelVariantConfigListCopier.copyFromBuilder(desiredModelVariants);
        }

        @Override
        public final Builder desiredModelVariants(Collection<ModelVariantConfig> desiredModelVariants) {
            this.desiredModelVariants = ModelVariantConfigListCopier.copy(desiredModelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredModelVariants(ModelVariantConfig ... desiredModelVariants) {
            this.desiredModelVariants(Arrays.asList(desiredModelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredModelVariants(Consumer<ModelVariantConfig.Builder> ... desiredModelVariants) {
            this.desiredModelVariants(Stream.of(desiredModelVariants).map(c -> (ModelVariantConfig)((ModelVariantConfig.Builder)ModelVariantConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(InferenceExperimentStopDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopInferenceExperimentRequest build() {
            return new StopInferenceExperimentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopInferenceExperimentRequest> {
        public Builder name(String var1);

        public Builder modelVariantActionsWithStrings(Map<String, String> var1);

        public Builder modelVariantActions(Map<String, ModelVariantAction> var1);

        public Builder desiredModelVariants(Collection<ModelVariantConfig> var1);

        public Builder desiredModelVariants(ModelVariantConfig ... var1);

        public Builder desiredModelVariants(Consumer<ModelVariantConfig.Builder> ... var1);

        public Builder desiredState(String var1);

        public Builder desiredState(InferenceExperimentStopDesiredState var1);

        public Builder reason(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

