/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortLineageGroupsBy;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLineageGroupsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListLineageGroupsRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(ListLineageGroupsRequest.getter(ListLineageGroupsRequest::createdAfter)).setter(ListLineageGroupsRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(ListLineageGroupsRequest.getter(ListLineageGroupsRequest::createdBefore)).setter(ListLineageGroupsRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListLineageGroupsRequest.getter(ListLineageGroupsRequest::sortByAsString)).setter(ListLineageGroupsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListLineageGroupsRequest.getter(ListLineageGroupsRequest::sortOrderAsString)).setter(ListLineageGroupsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLineageGroupsRequest.getter(ListLineageGroupsRequest::nextToken)).setter(ListLineageGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListLineageGroupsRequest.getter(ListLineageGroupsRequest::maxResults)).setter(ListLineageGroupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreatedAfter", CREATED_AFTER_FIELD);
            this.put("CreatedBefore", CREATED_BEFORE_FIELD);
            this.put("SortBy", SORT_BY_FIELD);
            this.put("SortOrder", SORT_ORDER_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final String sortBy;
    private final String sortOrder;
    private final String nextToken;
    private final Integer maxResults;

    private ListLineageGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final SortLineageGroupsBy sortBy() {
        return SortLineageGroupsBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLineageGroupsRequest)) {
            return false;
        }
        ListLineageGroupsRequest other = (ListLineageGroupsRequest)((Object)obj);
        return Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListLineageGroupsRequest").add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLineageGroupsRequest, T> g) {
        return obj -> g.apply((ListLineageGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private String sortBy;
        private String sortOrder;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLineageGroupsRequest model) {
            super(model);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortLineageGroupsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLineageGroupsRequest build() {
            return new ListLineageGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLineageGroupsRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortLineageGroupsBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

