/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFeatureMetadataRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeFeatureMetadataRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(DescribeFeatureMetadataRequest.getter(DescribeFeatureMetadataRequest::featureGroupName)).setter(DescribeFeatureMetadataRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(DescribeFeatureMetadataRequest.getter(DescribeFeatureMetadataRequest::featureName)).setter(DescribeFeatureMetadataRequest.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, FEATURE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
            this.put("FeatureName", FEATURE_NAME_FIELD);
        }
    });
    private final String featureGroupName;
    private final String featureName;

    private DescribeFeatureMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.featureName = builder.featureName;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String featureName() {
        return this.featureName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeatureMetadataRequest)) {
            return false;
        }
        DescribeFeatureMetadataRequest other = (DescribeFeatureMetadataRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.featureName(), other.featureName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFeatureMetadataRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("FeatureName", (Object)this.featureName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeatureMetadataRequest, T> g) {
        return obj -> g.apply((DescribeFeatureMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private String featureName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeatureMetadataRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.featureName(model.featureName);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFeatureMetadataRequest build() {
            return new DescribeFeatureMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFeatureMetadataRequest> {
        public Builder featureGroupName(String var1);

        public Builder featureName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

