/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringDatasetFormat;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchTransformInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchTransformInput> {
    private static final SdkField<String> DATA_CAPTURED_DESTINATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCapturedDestinationS3Uri").getter(BatchTransformInput.getter(BatchTransformInput::dataCapturedDestinationS3Uri)).setter(BatchTransformInput.setter(Builder::dataCapturedDestinationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCapturedDestinationS3Uri").build()}).build();
    private static final SdkField<MonitoringDatasetFormat> DATASET_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetFormat").getter(BatchTransformInput.getter(BatchTransformInput::datasetFormat)).setter(BatchTransformInput.setter(Builder::datasetFormat)).constructor(MonitoringDatasetFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetFormat").build()}).build();
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPath").getter(BatchTransformInput.getter(BatchTransformInput::localPath)).setter(BatchTransformInput.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> S3_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3InputMode").getter(BatchTransformInput.getter(BatchTransformInput::s3InputModeAsString)).setter(BatchTransformInput.setter(Builder::s3InputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputMode").build()}).build();
    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataDistributionType").getter(BatchTransformInput.getter(BatchTransformInput::s3DataDistributionTypeAsString)).setter(BatchTransformInput.setter(Builder::s3DataDistributionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build()}).build();
    private static final SdkField<String> FEATURES_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturesAttribute").getter(BatchTransformInput.getter(BatchTransformInput::featuresAttribute)).setter(BatchTransformInput.setter(Builder::featuresAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturesAttribute").build()}).build();
    private static final SdkField<String> INFERENCE_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceAttribute").getter(BatchTransformInput.getter(BatchTransformInput::inferenceAttribute)).setter(BatchTransformInput.setter(Builder::inferenceAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAttribute").build()}).build();
    private static final SdkField<String> PROBABILITY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProbabilityAttribute").getter(BatchTransformInput.getter(BatchTransformInput::probabilityAttribute)).setter(BatchTransformInput.setter(Builder::probabilityAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProbabilityAttribute").build()}).build();
    private static final SdkField<Double> PROBABILITY_THRESHOLD_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ProbabilityThresholdAttribute").getter(BatchTransformInput.getter(BatchTransformInput::probabilityThresholdAttribute)).setter(BatchTransformInput.setter(Builder::probabilityThresholdAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProbabilityThresholdAttribute").build()}).build();
    private static final SdkField<String> START_TIME_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTimeOffset").getter(BatchTransformInput.getter(BatchTransformInput::startTimeOffset)).setter(BatchTransformInput.setter(Builder::startTimeOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeOffset").build()}).build();
    private static final SdkField<String> END_TIME_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTimeOffset").getter(BatchTransformInput.getter(BatchTransformInput::endTimeOffset)).setter(BatchTransformInput.setter(Builder::endTimeOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimeOffset").build()}).build();
    private static final SdkField<String> EXCLUDE_FEATURES_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExcludeFeaturesAttribute").getter(BatchTransformInput.getter(BatchTransformInput::excludeFeaturesAttribute)).setter(BatchTransformInput.setter(Builder::excludeFeaturesAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFeaturesAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_CAPTURED_DESTINATION_S3_URI_FIELD, DATASET_FORMAT_FIELD, LOCAL_PATH_FIELD, S3_INPUT_MODE_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD, FEATURES_ATTRIBUTE_FIELD, INFERENCE_ATTRIBUTE_FIELD, PROBABILITY_ATTRIBUTE_FIELD, PROBABILITY_THRESHOLD_ATTRIBUTE_FIELD, START_TIME_OFFSET_FIELD, END_TIME_OFFSET_FIELD, EXCLUDE_FEATURES_ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataCapturedDestinationS3Uri", DATA_CAPTURED_DESTINATION_S3_URI_FIELD);
            this.put("DatasetFormat", DATASET_FORMAT_FIELD);
            this.put("LocalPath", LOCAL_PATH_FIELD);
            this.put("S3InputMode", S3_INPUT_MODE_FIELD);
            this.put("S3DataDistributionType", S3_DATA_DISTRIBUTION_TYPE_FIELD);
            this.put("FeaturesAttribute", FEATURES_ATTRIBUTE_FIELD);
            this.put("InferenceAttribute", INFERENCE_ATTRIBUTE_FIELD);
            this.put("ProbabilityAttribute", PROBABILITY_ATTRIBUTE_FIELD);
            this.put("ProbabilityThresholdAttribute", PROBABILITY_THRESHOLD_ATTRIBUTE_FIELD);
            this.put("StartTimeOffset", START_TIME_OFFSET_FIELD);
            this.put("EndTimeOffset", END_TIME_OFFSET_FIELD);
            this.put("ExcludeFeaturesAttribute", EXCLUDE_FEATURES_ATTRIBUTE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataCapturedDestinationS3Uri;
    private final MonitoringDatasetFormat datasetFormat;
    private final String localPath;
    private final String s3InputMode;
    private final String s3DataDistributionType;
    private final String featuresAttribute;
    private final String inferenceAttribute;
    private final String probabilityAttribute;
    private final Double probabilityThresholdAttribute;
    private final String startTimeOffset;
    private final String endTimeOffset;
    private final String excludeFeaturesAttribute;

    private BatchTransformInput(BuilderImpl builder) {
        this.dataCapturedDestinationS3Uri = builder.dataCapturedDestinationS3Uri;
        this.datasetFormat = builder.datasetFormat;
        this.localPath = builder.localPath;
        this.s3InputMode = builder.s3InputMode;
        this.s3DataDistributionType = builder.s3DataDistributionType;
        this.featuresAttribute = builder.featuresAttribute;
        this.inferenceAttribute = builder.inferenceAttribute;
        this.probabilityAttribute = builder.probabilityAttribute;
        this.probabilityThresholdAttribute = builder.probabilityThresholdAttribute;
        this.startTimeOffset = builder.startTimeOffset;
        this.endTimeOffset = builder.endTimeOffset;
        this.excludeFeaturesAttribute = builder.excludeFeaturesAttribute;
    }

    public final String dataCapturedDestinationS3Uri() {
        return this.dataCapturedDestinationS3Uri;
    }

    public final MonitoringDatasetFormat datasetFormat() {
        return this.datasetFormat;
    }

    public final String localPath() {
        return this.localPath;
    }

    public final ProcessingS3InputMode s3InputMode() {
        return ProcessingS3InputMode.fromValue(this.s3InputMode);
    }

    public final String s3InputModeAsString() {
        return this.s3InputMode;
    }

    public final ProcessingS3DataDistributionType s3DataDistributionType() {
        return ProcessingS3DataDistributionType.fromValue(this.s3DataDistributionType);
    }

    public final String s3DataDistributionTypeAsString() {
        return this.s3DataDistributionType;
    }

    public final String featuresAttribute() {
        return this.featuresAttribute;
    }

    public final String inferenceAttribute() {
        return this.inferenceAttribute;
    }

    public final String probabilityAttribute() {
        return this.probabilityAttribute;
    }

    public final Double probabilityThresholdAttribute() {
        return this.probabilityThresholdAttribute;
    }

    public final String startTimeOffset() {
        return this.startTimeOffset;
    }

    public final String endTimeOffset() {
        return this.endTimeOffset;
    }

    public final String excludeFeaturesAttribute() {
        return this.excludeFeaturesAttribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCapturedDestinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.featuresAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.probabilityAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.probabilityThresholdAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeFeaturesAttribute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchTransformInput)) {
            return false;
        }
        BatchTransformInput other = (BatchTransformInput)obj;
        return Objects.equals(this.dataCapturedDestinationS3Uri(), other.dataCapturedDestinationS3Uri()) && Objects.equals(this.datasetFormat(), other.datasetFormat()) && Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3InputModeAsString(), other.s3InputModeAsString()) && Objects.equals(this.s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString()) && Objects.equals(this.featuresAttribute(), other.featuresAttribute()) && Objects.equals(this.inferenceAttribute(), other.inferenceAttribute()) && Objects.equals(this.probabilityAttribute(), other.probabilityAttribute()) && Objects.equals(this.probabilityThresholdAttribute(), other.probabilityThresholdAttribute()) && Objects.equals(this.startTimeOffset(), other.startTimeOffset()) && Objects.equals(this.endTimeOffset(), other.endTimeOffset()) && Objects.equals(this.excludeFeaturesAttribute(), other.excludeFeaturesAttribute());
    }

    public final String toString() {
        return ToString.builder((String)"BatchTransformInput").add("DataCapturedDestinationS3Uri", (Object)this.dataCapturedDestinationS3Uri()).add("DatasetFormat", (Object)this.datasetFormat()).add("LocalPath", (Object)this.localPath()).add("S3InputMode", (Object)this.s3InputModeAsString()).add("S3DataDistributionType", (Object)this.s3DataDistributionTypeAsString()).add("FeaturesAttribute", (Object)this.featuresAttribute()).add("InferenceAttribute", (Object)this.inferenceAttribute()).add("ProbabilityAttribute", (Object)this.probabilityAttribute()).add("ProbabilityThresholdAttribute", (Object)this.probabilityThresholdAttribute()).add("StartTimeOffset", (Object)this.startTimeOffset()).add("EndTimeOffset", (Object)this.endTimeOffset()).add("ExcludeFeaturesAttribute", (Object)this.excludeFeaturesAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataCapturedDestinationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.dataCapturedDestinationS3Uri()));
            }
            case "DatasetFormat": {
                return Optional.ofNullable(clazz.cast(this.datasetFormat()));
            }
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "S3InputMode": {
                return Optional.ofNullable(clazz.cast(this.s3InputModeAsString()));
            }
            case "S3DataDistributionType": {
                return Optional.ofNullable(clazz.cast(this.s3DataDistributionTypeAsString()));
            }
            case "FeaturesAttribute": {
                return Optional.ofNullable(clazz.cast(this.featuresAttribute()));
            }
            case "InferenceAttribute": {
                return Optional.ofNullable(clazz.cast(this.inferenceAttribute()));
            }
            case "ProbabilityAttribute": {
                return Optional.ofNullable(clazz.cast(this.probabilityAttribute()));
            }
            case "ProbabilityThresholdAttribute": {
                return Optional.ofNullable(clazz.cast(this.probabilityThresholdAttribute()));
            }
            case "StartTimeOffset": {
                return Optional.ofNullable(clazz.cast(this.startTimeOffset()));
            }
            case "EndTimeOffset": {
                return Optional.ofNullable(clazz.cast(this.endTimeOffset()));
            }
            case "ExcludeFeaturesAttribute": {
                return Optional.ofNullable(clazz.cast(this.excludeFeaturesAttribute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchTransformInput, T> g) {
        return obj -> g.apply((BatchTransformInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataCapturedDestinationS3Uri;
        private MonitoringDatasetFormat datasetFormat;
        private String localPath;
        private String s3InputMode;
        private String s3DataDistributionType;
        private String featuresAttribute;
        private String inferenceAttribute;
        private String probabilityAttribute;
        private Double probabilityThresholdAttribute;
        private String startTimeOffset;
        private String endTimeOffset;
        private String excludeFeaturesAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchTransformInput model) {
            this.dataCapturedDestinationS3Uri(model.dataCapturedDestinationS3Uri);
            this.datasetFormat(model.datasetFormat);
            this.localPath(model.localPath);
            this.s3InputMode(model.s3InputMode);
            this.s3DataDistributionType(model.s3DataDistributionType);
            this.featuresAttribute(model.featuresAttribute);
            this.inferenceAttribute(model.inferenceAttribute);
            this.probabilityAttribute(model.probabilityAttribute);
            this.probabilityThresholdAttribute(model.probabilityThresholdAttribute);
            this.startTimeOffset(model.startTimeOffset);
            this.endTimeOffset(model.endTimeOffset);
            this.excludeFeaturesAttribute(model.excludeFeaturesAttribute);
        }

        public final String getDataCapturedDestinationS3Uri() {
            return this.dataCapturedDestinationS3Uri;
        }

        public final void setDataCapturedDestinationS3Uri(String dataCapturedDestinationS3Uri) {
            this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
        }

        @Override
        public final Builder dataCapturedDestinationS3Uri(String dataCapturedDestinationS3Uri) {
            this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
            return this;
        }

        public final MonitoringDatasetFormat.Builder getDatasetFormat() {
            return this.datasetFormat != null ? this.datasetFormat.toBuilder() : null;
        }

        public final void setDatasetFormat(MonitoringDatasetFormat.BuilderImpl datasetFormat) {
            this.datasetFormat = datasetFormat != null ? datasetFormat.build() : null;
        }

        @Override
        public final Builder datasetFormat(MonitoringDatasetFormat datasetFormat) {
            this.datasetFormat = datasetFormat;
            return this;
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final String getS3InputMode() {
            return this.s3InputMode;
        }

        public final void setS3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
        }

        @Override
        public final Builder s3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
            return this;
        }

        @Override
        public final Builder s3InputMode(ProcessingS3InputMode s3InputMode) {
            this.s3InputMode(s3InputMode == null ? null : s3InputMode.toString());
            return this;
        }

        public final String getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final String getFeaturesAttribute() {
            return this.featuresAttribute;
        }

        public final void setFeaturesAttribute(String featuresAttribute) {
            this.featuresAttribute = featuresAttribute;
        }

        @Override
        public final Builder featuresAttribute(String featuresAttribute) {
            this.featuresAttribute = featuresAttribute;
            return this;
        }

        public final String getInferenceAttribute() {
            return this.inferenceAttribute;
        }

        public final void setInferenceAttribute(String inferenceAttribute) {
            this.inferenceAttribute = inferenceAttribute;
        }

        @Override
        public final Builder inferenceAttribute(String inferenceAttribute) {
            this.inferenceAttribute = inferenceAttribute;
            return this;
        }

        public final String getProbabilityAttribute() {
            return this.probabilityAttribute;
        }

        public final void setProbabilityAttribute(String probabilityAttribute) {
            this.probabilityAttribute = probabilityAttribute;
        }

        @Override
        public final Builder probabilityAttribute(String probabilityAttribute) {
            this.probabilityAttribute = probabilityAttribute;
            return this;
        }

        public final Double getProbabilityThresholdAttribute() {
            return this.probabilityThresholdAttribute;
        }

        public final void setProbabilityThresholdAttribute(Double probabilityThresholdAttribute) {
            this.probabilityThresholdAttribute = probabilityThresholdAttribute;
        }

        @Override
        public final Builder probabilityThresholdAttribute(Double probabilityThresholdAttribute) {
            this.probabilityThresholdAttribute = probabilityThresholdAttribute;
            return this;
        }

        public final String getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public final void setStartTimeOffset(String startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
        }

        @Override
        public final Builder startTimeOffset(String startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
            return this;
        }

        public final String getEndTimeOffset() {
            return this.endTimeOffset;
        }

        public final void setEndTimeOffset(String endTimeOffset) {
            this.endTimeOffset = endTimeOffset;
        }

        @Override
        public final Builder endTimeOffset(String endTimeOffset) {
            this.endTimeOffset = endTimeOffset;
            return this;
        }

        public final String getExcludeFeaturesAttribute() {
            return this.excludeFeaturesAttribute;
        }

        public final void setExcludeFeaturesAttribute(String excludeFeaturesAttribute) {
            this.excludeFeaturesAttribute = excludeFeaturesAttribute;
        }

        @Override
        public final Builder excludeFeaturesAttribute(String excludeFeaturesAttribute) {
            this.excludeFeaturesAttribute = excludeFeaturesAttribute;
            return this;
        }

        public BatchTransformInput build() {
            return new BatchTransformInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchTransformInput> {
        public Builder dataCapturedDestinationS3Uri(String var1);

        public Builder datasetFormat(MonitoringDatasetFormat var1);

        default public Builder datasetFormat(Consumer<MonitoringDatasetFormat.Builder> datasetFormat) {
            return this.datasetFormat((MonitoringDatasetFormat)((MonitoringDatasetFormat.Builder)MonitoringDatasetFormat.builder().applyMutation(datasetFormat)).build());
        }

        public Builder localPath(String var1);

        public Builder s3InputMode(String var1);

        public Builder s3InputMode(ProcessingS3InputMode var1);

        public Builder s3DataDistributionType(String var1);

        public Builder s3DataDistributionType(ProcessingS3DataDistributionType var1);

        public Builder featuresAttribute(String var1);

        public Builder inferenceAttribute(String var1);

        public Builder probabilityAttribute(String var1);

        public Builder probabilityThresholdAttribute(Double var1);

        public Builder startTimeOffset(String var1);

        public Builder endTimeOffset(String var1);

        public Builder excludeFeaturesAttribute(String var1);
    }
}

