/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessGrantsInstanceResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, CreateAccessGrantsInstanceResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateAccessGrantsInstanceResponse.getter(CreateAccessGrantsInstanceResponse::createdAt)).setter(CreateAccessGrantsInstanceResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").unmarshallLocationName("CreatedAt").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsInstanceId").getter(CreateAccessGrantsInstanceResponse.getter(CreateAccessGrantsInstanceResponse::accessGrantsInstanceId)).setter(CreateAccessGrantsInstanceResponse.setter(Builder::accessGrantsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceId").unmarshallLocationName("AccessGrantsInstanceId").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsInstanceArn").getter(CreateAccessGrantsInstanceResponse.getter(CreateAccessGrantsInstanceResponse::accessGrantsInstanceArn)).setter(CreateAccessGrantsInstanceResponse.setter(Builder::accessGrantsInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceArn").unmarshallLocationName("AccessGrantsInstanceArn").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterArn").getter(CreateAccessGrantsInstanceResponse.getter(CreateAccessGrantsInstanceResponse::identityCenterArn)).setter(CreateAccessGrantsInstanceResponse.setter(Builder::identityCenterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterArn").unmarshallLocationName("IdentityCenterArn").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterInstanceArn").getter(CreateAccessGrantsInstanceResponse.getter(CreateAccessGrantsInstanceResponse::identityCenterInstanceArn)).setter(CreateAccessGrantsInstanceResponse.setter(Builder::identityCenterInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterInstanceArn").unmarshallLocationName("IdentityCenterInstanceArn").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterApplicationArn").getter(CreateAccessGrantsInstanceResponse.getter(CreateAccessGrantsInstanceResponse::identityCenterApplicationArn)).setter(CreateAccessGrantsInstanceResponse.setter(Builder::identityCenterApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterApplicationArn").unmarshallLocationName("IdentityCenterApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ACCESS_GRANTS_INSTANCE_ID_FIELD, ACCESS_GRANTS_INSTANCE_ARN_FIELD, IDENTITY_CENTER_ARN_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD, IDENTITY_CENTER_APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("AccessGrantsInstanceId", ACCESS_GRANTS_INSTANCE_ID_FIELD);
            this.put("AccessGrantsInstanceArn", ACCESS_GRANTS_INSTANCE_ARN_FIELD);
            this.put("IdentityCenterArn", IDENTITY_CENTER_ARN_FIELD);
            this.put("IdentityCenterInstanceArn", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
            this.put("IdentityCenterApplicationArn", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        }
    });
    private final Instant createdAt;
    private final String accessGrantsInstanceId;
    private final String accessGrantsInstanceArn;
    private final String identityCenterArn;
    private final String identityCenterInstanceArn;
    private final String identityCenterApplicationArn;

    private CreateAccessGrantsInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.accessGrantsInstanceId = builder.accessGrantsInstanceId;
        this.accessGrantsInstanceArn = builder.accessGrantsInstanceArn;
        this.identityCenterArn = builder.identityCenterArn;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String accessGrantsInstanceId() {
        return this.accessGrantsInstanceId;
    }

    public final String accessGrantsInstanceArn() {
        return this.accessGrantsInstanceArn;
    }

    @Deprecated
    public final String identityCenterArn() {
        return this.identityCenterArn;
    }

    public final String identityCenterInstanceArn() {
        return this.identityCenterInstanceArn;
    }

    public final String identityCenterApplicationArn() {
        return this.identityCenterApplicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantsInstanceResponse)) {
            return false;
        }
        CreateAccessGrantsInstanceResponse other = (CreateAccessGrantsInstanceResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.accessGrantsInstanceId(), other.accessGrantsInstanceId()) && Objects.equals(this.accessGrantsInstanceArn(), other.accessGrantsInstanceArn()) && Objects.equals(this.identityCenterArn(), other.identityCenterArn()) && Objects.equals(this.identityCenterInstanceArn(), other.identityCenterInstanceArn()) && Objects.equals(this.identityCenterApplicationArn(), other.identityCenterApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessGrantsInstanceResponse").add("CreatedAt", (Object)this.createdAt()).add("AccessGrantsInstanceId", (Object)this.accessGrantsInstanceId()).add("AccessGrantsInstanceArn", (Object)this.accessGrantsInstanceArn()).add("IdentityCenterArn", (Object)this.identityCenterArn()).add("IdentityCenterInstanceArn", (Object)this.identityCenterInstanceArn()).add("IdentityCenterApplicationArn", (Object)this.identityCenterApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "AccessGrantsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsInstanceId()));
            }
            case "AccessGrantsInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsInstanceArn()));
            }
            case "IdentityCenterArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterArn()));
            }
            case "IdentityCenterInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterInstanceArn()));
            }
            case "IdentityCenterApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessGrantsInstanceResponse, T> g) {
        return obj -> g.apply((CreateAccessGrantsInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String accessGrantsInstanceId;
        private String accessGrantsInstanceArn;
        private String identityCenterArn;
        private String identityCenterInstanceArn;
        private String identityCenterApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessGrantsInstanceResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.accessGrantsInstanceId(model.accessGrantsInstanceId);
            this.accessGrantsInstanceArn(model.accessGrantsInstanceArn);
            this.identityCenterArn(model.identityCenterArn);
            this.identityCenterInstanceArn(model.identityCenterInstanceArn);
            this.identityCenterApplicationArn(model.identityCenterApplicationArn);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAccessGrantsInstanceId() {
            return this.accessGrantsInstanceId;
        }

        public final void setAccessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
        }

        @Override
        public final Builder accessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
            return this;
        }

        public final String getAccessGrantsInstanceArn() {
            return this.accessGrantsInstanceArn;
        }

        public final void setAccessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
        }

        @Override
        public final Builder accessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
            return this;
        }

        @Deprecated
        public final String getIdentityCenterArn() {
            return this.identityCenterArn;
        }

        @Deprecated
        public final void setIdentityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
        }

        @Override
        @Deprecated
        public final Builder identityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return this.identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final String getIdentityCenterApplicationArn() {
            return this.identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        @Override
        public CreateAccessGrantsInstanceResponse build() {
            return new CreateAccessGrantsInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessGrantsInstanceResponse> {
        public Builder createdAt(Instant var1);

        public Builder accessGrantsInstanceId(String var1);

        public Builder accessGrantsInstanceArn(String var1);

        @Deprecated
        public Builder identityCenterArn(String var1);

        public Builder identityCenterInstanceArn(String var1);

        public Builder identityCenterApplicationArn(String var1);
    }
}

