/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class ReplicationEventData {
    private final String replicationRuleId;
    private final String destinationBucket;
    private final String s3Operation;
    private final String requestTime;
    private final String failureReason;
    private final String threshold;
    private final String replicationTime;

    public ReplicationEventData(String replicationRuleId, String destinationBucket, String s3Operation, String requestTime, String failureReason, String threshold, String replicationTime) {
        this.replicationRuleId = replicationRuleId;
        this.destinationBucket = destinationBucket;
        this.s3Operation = s3Operation;
        this.requestTime = requestTime;
        this.failureReason = failureReason;
        this.threshold = threshold;
        this.replicationTime = replicationTime;
    }

    public String getReplicationRuleId() {
        return this.replicationRuleId;
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public String getS3Operation() {
        return this.s3Operation;
    }

    public String getRequestTime() {
        return this.requestTime;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getReplicationTime() {
        return this.replicationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationEventData that = (ReplicationEventData)o;
        if (!Objects.equals(this.replicationRuleId, that.replicationRuleId)) {
            return false;
        }
        if (!Objects.equals(this.destinationBucket, that.destinationBucket)) {
            return false;
        }
        if (!Objects.equals(this.s3Operation, that.s3Operation)) {
            return false;
        }
        if (!Objects.equals(this.requestTime, that.requestTime)) {
            return false;
        }
        if (!Objects.equals(this.failureReason, that.failureReason)) {
            return false;
        }
        if (!Objects.equals(this.threshold, that.threshold)) {
            return false;
        }
        return Objects.equals(this.replicationTime, that.replicationTime);
    }

    public int hashCode() {
        int result = this.replicationRuleId != null ? this.replicationRuleId.hashCode() : 0;
        result = 31 * result + (this.destinationBucket != null ? this.destinationBucket.hashCode() : 0);
        result = 31 * result + (this.s3Operation != null ? this.s3Operation.hashCode() : 0);
        result = 31 * result + (this.requestTime != null ? this.requestTime.hashCode() : 0);
        result = 31 * result + (this.failureReason != null ? this.failureReason.hashCode() : 0);
        result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
        result = 31 * result + (this.replicationTime != null ? this.replicationTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"ReplicationEventData").add("replicationRuleId", (Object)this.replicationRuleId).add("destinationBucket", (Object)this.destinationBucket).add("s3Operation", (Object)this.s3Operation).add("requestTime", (Object)this.requestTime).add("failureReason", (Object)this.failureReason).add("threshold", (Object)this.threshold).add("replicationTime", (Object)this.replicationTime).build();
    }
}

