/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.QueryFilter;
import software.amazon.awssdk.services.rum.model.QueryFiltersCopier;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.services.rum.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppMonitorDataRequest
extends RumRequest
implements ToCopyableBuilder<Builder, GetAppMonitorDataRequest> {
    private static final SdkField<List<QueryFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GetAppMonitorDataRequest.getter(GetAppMonitorDataRequest::filters)).setter(GetAppMonitorDataRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetAppMonitorDataRequest.getter(GetAppMonitorDataRequest::maxResults)).setter(GetAppMonitorDataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetAppMonitorDataRequest.getter(GetAppMonitorDataRequest::name)).setter(GetAppMonitorDataRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetAppMonitorDataRequest.getter(GetAppMonitorDataRequest::nextToken)).setter(GetAppMonitorDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<TimeRange> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRange").getter(GetAppMonitorDataRequest.getter(GetAppMonitorDataRequest::timeRange)).setter(GetAppMonitorDataRequest.setter(Builder::timeRange)).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, TIME_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Filters", FILTERS_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("TimeRange", TIME_RANGE_FIELD);
        }
    });
    private final List<QueryFilter> filters;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final TimeRange timeRange;

    private GetAppMonitorDataRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.timeRange = builder.timeRange;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<QueryFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final TimeRange timeRange() {
        return this.timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppMonitorDataRequest)) {
            return false;
        }
        GetAppMonitorDataRequest other = (GetAppMonitorDataRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.timeRange(), other.timeRange());
    }

    public final String toString() {
        return ToString.builder((String)"GetAppMonitorDataRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("Name", (Object)this.name()).add("NextToken", (Object)this.nextToken()).add("TimeRange", (Object)this.timeRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TimeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAppMonitorDataRequest, T> g) {
        return obj -> g.apply((GetAppMonitorDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private List<QueryFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String name;
        private String nextToken;
        private TimeRange timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppMonitorDataRequest model) {
            super(model);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.timeRange(model.timeRange);
        }

        public final List<QueryFilter.Builder> getFilters() {
            List<QueryFilter.Builder> result = QueryFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<QueryFilter.BuilderImpl> filters) {
            this.filters = QueryFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<QueryFilter> filters) {
            this.filters = QueryFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(QueryFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<QueryFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (QueryFilter)((QueryFilter.Builder)QueryFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final TimeRange.Builder getTimeRange() {
            return this.timeRange != null ? this.timeRange.toBuilder() : null;
        }

        public final void setTimeRange(TimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAppMonitorDataRequest build() {
            return new GetAppMonitorDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppMonitorDataRequest> {
        public Builder filters(Collection<QueryFilter> var1);

        public Builder filters(QueryFilter ... var1);

        public Builder filters(Consumer<QueryFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder timeRange(TimeRange var1);

        default public Builder timeRange(Consumer<TimeRange.Builder> timeRange) {
            return this.timeRange((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(timeRange)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

