/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Resource;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagsCopier;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceSetResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, UpdateResourceSetResponse> {
    private static final SdkField<String> RESOURCE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetArn").getter(UpdateResourceSetResponse.getter(UpdateResourceSetResponse::resourceSetArn)).setter(UpdateResourceSetResponse.setter(Builder::resourceSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetArn").build()}).build();
    private static final SdkField<String> RESOURCE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetName").getter(UpdateResourceSetResponse.getter(UpdateResourceSetResponse::resourceSetName)).setter(UpdateResourceSetResponse.setter(Builder::resourceSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetName").build()}).build();
    private static final SdkField<String> RESOURCE_SET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetType").getter(UpdateResourceSetResponse.getter(UpdateResourceSetResponse::resourceSetType)).setter(UpdateResourceSetResponse.setter(Builder::resourceSetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetType").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(UpdateResourceSetResponse.getter(UpdateResourceSetResponse::resources)).setter(UpdateResourceSetResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateResourceSetResponse.getter(UpdateResourceSetResponse::tags)).setter(UpdateResourceSetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_ARN_FIELD, RESOURCE_SET_NAME_FIELD, RESOURCE_SET_TYPE_FIELD, RESOURCES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceSetArn", RESOURCE_SET_ARN_FIELD);
            this.put("resourceSetName", RESOURCE_SET_NAME_FIELD);
            this.put("resourceSetType", RESOURCE_SET_TYPE_FIELD);
            this.put("resources", RESOURCES_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String resourceSetArn;
    private final String resourceSetName;
    private final String resourceSetType;
    private final List<Resource> resources;
    private final Map<String, String> tags;

    private UpdateResourceSetResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSetArn = builder.resourceSetArn;
        this.resourceSetName = builder.resourceSetName;
        this.resourceSetType = builder.resourceSetType;
        this.resources = builder.resources;
        this.tags = builder.tags;
    }

    public final String resourceSetArn() {
        return this.resourceSetArn;
    }

    public final String resourceSetName() {
        return this.resourceSetName;
    }

    public final String resourceSetType() {
        return this.resourceSetType;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceSetResponse)) {
            return false;
        }
        UpdateResourceSetResponse other = (UpdateResourceSetResponse)((Object)obj);
        return Objects.equals(this.resourceSetArn(), other.resourceSetArn()) && Objects.equals(this.resourceSetName(), other.resourceSetName()) && Objects.equals(this.resourceSetType(), other.resourceSetType()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceSetResponse").add("ResourceSetArn", (Object)this.resourceSetArn()).add("ResourceSetName", (Object)this.resourceSetName()).add("ResourceSetType", (Object)this.resourceSetType()).add("Resources", this.hasResources() ? this.resources() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSetArn": {
                return Optional.ofNullable(clazz.cast(this.resourceSetArn()));
            }
            case "ResourceSetName": {
                return Optional.ofNullable(clazz.cast(this.resourceSetName()));
            }
            case "ResourceSetType": {
                return Optional.ofNullable(clazz.cast(this.resourceSetType()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceSetResponse, T> g) {
        return obj -> g.apply((UpdateResourceSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String resourceSetArn;
        private String resourceSetName;
        private String resourceSetType;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceSetResponse model) {
            super(model);
            this.resourceSetArn(model.resourceSetArn);
            this.resourceSetName(model.resourceSetName);
            this.resourceSetType(model.resourceSetType);
            this.resources(model.resources);
            this.tags(model.tags);
        }

        public final String getResourceSetArn() {
            return this.resourceSetArn;
        }

        public final void setResourceSetArn(String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
        }

        @Override
        public final Builder resourceSetArn(String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
            return this;
        }

        public final String getResourceSetName() {
            return this.resourceSetName;
        }

        public final void setResourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
        }

        @Override
        public final Builder resourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
            return this;
        }

        public final String getResourceSetType() {
            return this.resourceSetType;
        }

        public final void setResourceSetType(String resourceSetType) {
            this.resourceSetType = resourceSetType;
        }

        @Override
        public final Builder resourceSetType(String resourceSetType) {
            this.resourceSetType = resourceSetType;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ___listOfResourceCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ___listOfResourceCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ___listOfResourceCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateResourceSetResponse build() {
            return new UpdateResourceSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceSetResponse> {
        public Builder resourceSetArn(String var1);

        public Builder resourceSetName(String var1);

        public Builder resourceSetType(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

